/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.packet;

import com.meidusa.toolkit.net.packet.AbstractPacket;
import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;
import com.meidusa.toolkit.net.packet.PacketFactory;
import org.apache.log4j.Logger;

public abstract class AbstractPacketFactory<T extends AbstractPacket, V extends AbstractPacketBuffer>
implements PacketFactory<T> {
    private static final Logger logger = Logger.getLogger(AbstractPacketFactory.class);

    @Override
    public T createPacket(byte[] buffer) {
        try {
            AbstractPacket packet = (AbstractPacket)this.getPacketClass(buffer).newInstance();
            AbstractPacketBuffer packetBuffer = (AbstractPacketBuffer)this.getPacketBufferClass(buffer).newInstance();
            packet.init(packetBuffer);
            return (T)packet;
        }
        catch (Exception e) {
            logger.error((Object)"instance of packet Error", (Throwable)e);
            return null;
        }
    }

    protected abstract Class<T> getPacketClass(byte[] var1);

    protected abstract Class<V> getPacketBufferClass(byte[] var1);
}

