package com.meidusa.toolkit.net.util;

public interface BlockingQueue<T> extends Queue<T> {
	/**
	 * Gets the next item from the queue blocking for no longer than
	 * <code>maxwait</code> milliseconds waiting for an item to be added to
	 * the queue if it is empty at the time of invocation.
	 */
	public abstract T get(long maxwait);

	/**
	 * Gets the next item from the queue, blocking until an item is added to the
	 * queue if the queue is empty at time of invocation.
	 */
	public abstract T get();
}
