package com.meidusa.toolkit.net.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;

/*
 * <b> The Packet Header </b>
 * 
 * <pre>
 * Bytes                 Name
 *  -----                 ----
 * </p>
 * </pre>
 * 
 * */
public abstract class AbstractPacketMetaData {
	private static byte[] HEAD_PAD = null;

	public byte[] getHeadPad() {
		if (HEAD_PAD == null) {
			HEAD_PAD = new byte[this.getHeaderSize()];
		}
		return HEAD_PAD;
	}

	public abstract int getHeaderSize();

	/**
	 * decode length
	 * @param _buffer
	 * @return
	 */
	protected int decodeLength(ByteBuffer _buffer) {
		_buffer.rewind();

		/**
		 * ݲ֣ͷ=ݰ
		 */
		int length = _buffer.getInt();
		return length;
	}

	/**
	 * Ҫ<code>AbstractPacketBuffer.getByteOrder()</code> һ 
	 * @see AbstractPacketBuffer#getByteOrder()
	 * 
	 * @return
	 */
	public ByteOrder getByteOrder() {
		return ByteOrder.BIG_ENDIAN;
	}
}
