/**
 * <pre>
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU AFFERO GENERAL PUBLIC LICENSE as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU AFFERO GENERAL PUBLIC LICENSE for more details. 
 * 	You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * </pre>
 */
package com.meidusa.toolkit.net.authenticate.server;

import org.apache.log4j.Logger;

import com.meidusa.toolkit.net.AuthingableConnection;
import com.meidusa.toolkit.net.packet.AbstractPacket;

/**
 * @author <a href=mailto:piratebase@sina.com>Struct chen</a>
 */
public abstract class AbstractAuthenticateProvider<T extends AbstractPacket> implements AuthenticateProvider<T>{

    /** A code indicating that an internal server error occurred while
     * trying to log the user on. */
    public static final String SERVER_ERROR = "m.server_error";
    
    protected static Logger                log = Logger.getLogger(AbstractAuthenticateProvider.class);
    private AuthenticateFilter             filter;
    public boolean authenticateConnection(final AuthingableConnection conn,T authenPacket) {
        final AuthResponseData rdata = createResponseData();
        try {
        	if(authenPacket == null){
        		whenClientIllegalPacket(rdata);
        		return false;
        	}
            if (doFilte(conn, rdata)) {
                processAuthentication(conn, authenPacket,rdata);
                return true;
            }else{
            	return false;
            }
        } catch (Exception e) {
        	log.warn("Error authenticating", e);
        	whenServerException(e,rdata);
            return false;
        } finally {
        	conn.afterAuthing(rdata);
        }
    }

    protected void whenServerException(Exception e,AuthResponseData response){
    	response.code = 500;
    	response.message = e.getMessage();
    }
    
    protected void whenClientIllegalPacket(AuthResponseData rdata){
    	rdata.code = 403;
        rdata.message = "authen packet type error";
    }
    
    public AuthenticateFilter getFilter() {
        return filter;
    }

    public void setFilter(AuthenticateFilter filter) {
        this.filter = filter;
    }

    protected AuthResponseData createResponseData() {
        return new AuthResponseData();
    }

    protected boolean doFilte(AuthingableConnection conn, AuthResponseData rdata) {
        return (filter != null) ? filter.doFilte(conn, rdata) : true;
    }

    /**
     * ֤
     * 
     * @param conn Ҫ֤
     * @param rdata Ҫ
     */
    protected abstract void processAuthentication(AuthingableConnection conn,T authenPacket,AuthResponseData rdata);
}
