package com.meidusa.toolkit.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

import org.apache.log4j.Logger;

import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.net.AuthingableConnectionFactory;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.SocketChannelFactory;

/**
 * ӹ,ݿ⽻ӹ
 * @author struct
 *
 */
public abstract class ClientNIOConnectionFactory extends AuthingableConnectionFactory  implements Initialisable{
	private static Logger logger = Logger.getLogger(ClientNIOConnectionFactory.class);
	protected int port;
	protected String ipAddress;
	
	protected SocketChannelFactory socketChannelFactory;
	
	public SocketChannelFactory getSocketChannelFactory() {
		return socketChannelFactory;
	}

	public void setSocketChannelFactory(SocketChannelFactory socketChannelFactory) {
		this.socketChannelFactory = socketChannelFactory;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getIpAddress() {
		return ipAddress;
	}

	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	public void init() throws InitialisationException {
		this.setSocketChannelFactory(new SocketChannelFactory(){

			public SocketChannel createSokectChannel() throws IOException {
				SocketChannel socketChannel = null;
				try{
					if(ipAddress == null){
						socketChannel = SocketChannel.open(new InetSocketAddress(port));
					}else{
						socketChannel = SocketChannel.open(new InetSocketAddress(ipAddress, port));
					}
					socketChannel.configureBlocking(false);
					if(logger.isInfoEnabled()){
						logger.info("open socket channel to server["+ipAddress+":"+port+"] success,local port="+socketChannel.socket().getLocalPort());
					}
				}catch(IOException e){
					logger.error("could not connect to server["+ipAddress+":"+port+"]",e);
					throw e;
				}
				return socketChannel;
			}
		});
		
		//ConnectionManager conMgr = ProxyRuntimeContext.getInstance().getConnectionManagerList().get(manager);
		if(this.getConnectionManager() == null){
			throw new InitialisationException("connectionManager can not be null");
		}
	}
	
	protected void initConnection(Connection connection) throws IOException{
		super.initConnection(connection);
		this.getConnectionManager().postRegisterNetEventHandler(connection, SelectionKey.OP_READ);
	}
	
}
