/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class FieldInfo
implements Comparable<FieldInfo> {
    private final String name;
    private final Method method;
    private final Field field;
    private final Class<?> fieldClass;
    private final Type fieldType;
    private final boolean isTypeHandle;

    public String toString() {
        return "FieldInfo [name=" + this.name + ", method=" + this.method + ", field=" + this.field + ", fieldClass=" + this.fieldClass + ", fieldType=" + this.fieldType + ", isTypeHandle=" + this.isTypeHandle + "]";
    }

    public FieldInfo(String name, Method method, Field field, boolean isKey) {
        this.name = name;
        this.method = method;
        this.field = field;
        this.isTypeHandle = isKey;
        if (method.getParameterTypes().length == 1) {
            this.fieldClass = method.getParameterTypes()[0];
            this.fieldType = method.getGenericParameterTypes()[0];
        } else {
            this.fieldClass = method.getReturnType();
            this.fieldType = method.getGenericReturnType();
        }
    }

    public boolean isTypeHandle() {
        return this.isTypeHandle;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public Type getFieldType() {
        return this.fieldType;
    }

    public String getName() {
        return this.name;
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public int compareTo(FieldInfo o) {
        boolean i = false;
        if (this.isTypeHandle) {
            return -1;
        }
        return this.name.compareTo(o.name);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = null;
        annotation = this.method.getAnnotation(annotationClass);
        if (annotation == null && this.field != null) {
            annotation = this.field.getAnnotation(annotationClass);
        }
        return annotation;
    }
}

