/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.serializer.ASMSerializerFactory;
import com.meidusa.fastjson.serializer.AppendableSerializer;
import com.meidusa.fastjson.serializer.AtomicBooleanSerializer;
import com.meidusa.fastjson.serializer.AtomicIntegerArraySerializer;
import com.meidusa.fastjson.serializer.AtomicIntegerSerializer;
import com.meidusa.fastjson.serializer.AtomicLongArraySerializer;
import com.meidusa.fastjson.serializer.AtomicLongSerializer;
import com.meidusa.fastjson.serializer.AtomicReferenceSerializer;
import com.meidusa.fastjson.serializer.BigDecimalSerializer;
import com.meidusa.fastjson.serializer.BigIntegerSerializer;
import com.meidusa.fastjson.serializer.BooleanArraySerializer;
import com.meidusa.fastjson.serializer.BooleanSerializer;
import com.meidusa.fastjson.serializer.ByteArraySerializer;
import com.meidusa.fastjson.serializer.CharacterSerializer;
import com.meidusa.fastjson.serializer.CharsetSerializer;
import com.meidusa.fastjson.serializer.ClassSerializer;
import com.meidusa.fastjson.serializer.CurrencySerializer;
import com.meidusa.fastjson.serializer.DoubleArraySerializer;
import com.meidusa.fastjson.serializer.DoubleSerializer;
import com.meidusa.fastjson.serializer.FileSerializer;
import com.meidusa.fastjson.serializer.FloatArraySerializer;
import com.meidusa.fastjson.serializer.FloatSerializer;
import com.meidusa.fastjson.serializer.InetAddressSerializer;
import com.meidusa.fastjson.serializer.InetSocketAddressSerializer;
import com.meidusa.fastjson.serializer.IntArraySerializer;
import com.meidusa.fastjson.serializer.IntegerSerializer;
import com.meidusa.fastjson.serializer.JavaBeanSerializer;
import com.meidusa.fastjson.serializer.LocaleSerializer;
import com.meidusa.fastjson.serializer.LongArraySerializer;
import com.meidusa.fastjson.serializer.LongSerializer;
import com.meidusa.fastjson.serializer.ObjectArraySerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.PatternSerializer;
import com.meidusa.fastjson.serializer.ShortArraySerializer;
import com.meidusa.fastjson.serializer.StringSerializer;
import com.meidusa.fastjson.serializer.TimeZoneSerializer;
import com.meidusa.fastjson.serializer.URISerializer;
import com.meidusa.fastjson.serializer.URLSerializer;
import com.meidusa.fastjson.serializer.UUIDSerializer;
import com.meidusa.fastjson.util.ASMUtils;
import com.meidusa.fastjson.util.IdentityHashMap;
import java.io.File;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class SerializeConfig
extends IdentityHashMap<Type, ObjectSerializer> {
    private static final SerializeConfig globalInstance = new SerializeConfig();
    private boolean asm = !ASMUtils.isAndroid();
    private final ASMSerializerFactory asmFactory = new ASMSerializerFactory();

    public final ObjectSerializer createASMSerializer(Class<?> clazz) throws Exception {
        return this.asmFactory.createJavaBeanSerializer(clazz);
    }

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return new JavaBeanSerializer(clazz);
        }
        if (this.asm) {
            try {
                return this.createASMSerializer(clazz);
            }
            catch (Throwable e) {
                throw new JSONException("create asm serilizer error, class " + clazz, e);
            }
        }
        return new JavaBeanSerializer(clazz);
    }

    public boolean isAsmEnable() {
        return this.asm;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asm = asmEnable;
    }

    public static final SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(1024);
    }

    public SerializeConfig(int tableSize) {
        super(tableSize);
        this.put(Boolean.class, BooleanSerializer.instance);
        this.put(Character.class, CharacterSerializer.instance);
        this.put(Byte.class, IntegerSerializer.instance);
        this.put(Short.class, IntegerSerializer.instance);
        this.put(Integer.class, IntegerSerializer.instance);
        this.put(Long.class, LongSerializer.instance);
        this.put(Float.class, FloatSerializer.instance);
        this.put(Double.class, DoubleSerializer.instance);
        this.put(BigDecimal.class, BigDecimalSerializer.instance);
        this.put(BigInteger.class, BigIntegerSerializer.instance);
        this.put(String.class, StringSerializer.instance);
        this.put(byte[].class, ByteArraySerializer.instance);
        this.put(short[].class, ShortArraySerializer.instance);
        this.put(int[].class, IntArraySerializer.instance);
        this.put(long[].class, LongArraySerializer.instance);
        this.put(float[].class, FloatArraySerializer.instance);
        this.put(double[].class, DoubleArraySerializer.instance);
        this.put(boolean[].class, BooleanArraySerializer.instance);
        this.put(Object[].class, ObjectArraySerializer.instance);
        this.put(Class.class, ClassSerializer.instance);
        this.put(Locale.class, LocaleSerializer.instance);
        this.put(TimeZone.class, TimeZoneSerializer.instance);
        this.put(UUID.class, UUIDSerializer.instance);
        this.put(InetAddress.class, InetAddressSerializer.instance);
        this.put(Inet4Address.class, InetAddressSerializer.instance);
        this.put(Inet6Address.class, InetAddressSerializer.instance);
        this.put(InetSocketAddress.class, InetSocketAddressSerializer.instance);
        this.put(File.class, FileSerializer.instance);
        this.put(URI.class, URISerializer.instance);
        this.put(URL.class, URLSerializer.instance);
        this.put(Appendable.class, AppendableSerializer.instance);
        this.put(StringBuffer.class, AppendableSerializer.instance);
        this.put(StringBuilder.class, AppendableSerializer.instance);
        this.put(Pattern.class, PatternSerializer.instance);
        this.put(Charset.class, CharsetSerializer.instance);
        this.put(AtomicBoolean.class, AtomicBooleanSerializer.instance);
        this.put(AtomicInteger.class, AtomicIntegerSerializer.instance);
        this.put(AtomicLong.class, AtomicLongSerializer.instance);
        this.put(AtomicReference.class, AtomicReferenceSerializer.instance);
        this.put(AtomicIntegerArray.class, AtomicIntegerArraySerializer.instance);
        this.put(AtomicLongArray.class, AtomicLongArraySerializer.instance);
        this.put(Currency.class, CurrencySerializer.instance);
    }
}

