/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.annotation.JSONField;
import com.meidusa.fastjson.annotation.TypeHandleKey;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.Feature;
import com.meidusa.fastjson.parser.JSONScanner;
import com.meidusa.fastjson.parser.JSONToken;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.parser.deserializer.FieldDeserializer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import com.meidusa.fastjson.util.FieldInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JavaBeanDeserializer
implements ObjectDeserializer {
    private final Map<String, FieldDeserializer> setters = new IdentityHashMap<String, FieldDeserializer>();
    private final List<FieldDeserializer> fieldDeserializers = new ArrayList<FieldDeserializer>();
    private final Class<?> clazz;
    private Constructor<?> constructor;

    public Map<String, FieldDeserializer> getFieldDeserializerMap() {
        return this.setters;
    }

    public JavaBeanDeserializer(ParserConfig mapping, Class<?> clazz) {
        this.clazz = clazz;
        if (!Modifier.isAbstract(clazz.getModifiers())) {
            try {
                this.constructor = clazz.getDeclaredConstructor(new Class[0]);
                this.constructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new JSONException("class not has default constructor : " + clazz.getName());
            }
        }
        List<FieldInfo> fieldInfoList = JavaBeanDeserializer.computeSetters(clazz);
        for (FieldInfo fieldInfo : fieldInfoList) {
            this.addFieldDeserializer(mapping, clazz, fieldInfo);
        }
    }

    public static String getTypeHandleKey(Class<?> clazz, Class<?> stopClazz) {
        for (Class<?> superClazz = clazz; superClazz != stopClazz && superClazz != Object.class; superClazz = superClazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = superClazz.getDeclaredFields()) {
                TypeHandleKey typeHandle = field.getAnnotation(TypeHandleKey.class);
                if (typeHandle == null) continue;
                return field.getName();
            }
        }
        return null;
    }

    public static List<FieldInfo> computeSetters(Class<?> clazz) {
        HashMap<String, FieldInfo> setterMap = new HashMap<String, FieldInfo>();
        String handleKey = JavaBeanDeserializer.getTypeHandleKey(clazz, Object.class);
        for (Method method : clazz.getMethods()) {
            JSONField fieldAnnotation;
            String propertyName;
            String methodName = method.getName();
            if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation != null) {
                if (!annotation.deserialize()) continue;
                if (annotation.name().length() != 0) {
                    propertyName = annotation.name();
                    setterMap.put(propertyName, new FieldInfo(propertyName, method, null, propertyName.equals(handleKey)));
                    method.setAccessible(true);
                    continue;
                }
            }
            if (!methodName.startsWith("set") || !Character.isUpperCase(methodName.charAt(3))) continue;
            propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            Field field = JavaBeanDeserializer.getField(clazz, propertyName);
            if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null && fieldAnnotation.name().length() != 0) {
                propertyName = fieldAnnotation.name();
                setterMap.put(propertyName, new FieldInfo(propertyName, method, field, propertyName.equals(handleKey)));
                continue;
            }
            setterMap.put(propertyName, new FieldInfo(propertyName, method, null, propertyName.equals(handleKey)));
            method.setAccessible(true);
        }
        return new LinkedList<FieldInfo>(setterMap.values());
    }

    private void addFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        FieldDeserializer fieldDeserializer = this.createFieldDeserializer(mapping, clazz, fieldInfo);
        this.setters.put(fieldInfo.getName().intern(), fieldDeserializer);
        this.fieldDeserializers.add(fieldDeserializer);
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        return mapping.createFieldDeserializer(mapping, clazz, fieldInfo);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object createInstance(DefaultExtJSONParser parser, Type type) {
        Object object;
        try {
            object = this.constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JSONException("create instance error, class " + this.clazz.getName(), e);
        }
        return object;
    }

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        Object object;
        JSONScanner lexer;
        block7: {
            lexer = (JSONScanner)parser.getLexer();
            if (lexer.token() == 8) {
                lexer.nextToken(16);
                return null;
            }
            object = this.createInstance(parser, type);
            if (lexer.token() != 12) {
                throw new JSONException("syntax error, expect {, actual " + JSONToken.name(lexer.token()));
            }
            while (true) {
                boolean match;
                String key;
                if ((key = lexer.scanSymbol(parser.getSymbolTable())) == null) {
                    if (lexer.token() != 13) {
                        if (lexer.token() == 16 && parser.isEnabled(Feature.AllowArbitraryCommas)) continue;
                    }
                    break block7;
                }
                if (!(match = this.parseField(parser, key, object))) {
                    if (lexer.token() != 13) continue;
                    lexer.nextToken();
                    return (T)object;
                }
                if (lexer.token() == 16) continue;
                if (lexer.token() == 13) {
                    lexer.nextToken(16);
                    return (T)object;
                }
                if (lexer.token() == 18 || lexer.token() == 1) break;
            }
            throw new JSONException("syntax error, unexpect token " + JSONToken.name(lexer.token()));
        }
        lexer.nextToken(16);
        return (T)object;
    }

    public boolean parseField(DefaultExtJSONParser parser, String key, Object object) {
        JSONScanner lexer = (JSONScanner)parser.getLexer();
        FieldDeserializer fieldDeserializer = this.setters.get(key);
        if (fieldDeserializer == null) {
            if (!parser.isEnabled(Feature.IgnoreNotMatch)) {
                throw new JSONException("setter not found, class " + this.clazz.getName() + ", property " + key);
            }
            lexer.nextTokenWithColon();
            parser.parse();
            return false;
        }
        lexer.nextTokenWithColon(fieldDeserializer.getFastMatchToken());
        fieldDeserializer.parseField(parser, object);
        return true;
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

