package com.meidusa.fastjson.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

import com.meidusa.fastjson.annotation.TypeHandle;
import com.meidusa.fastjson.annotation.TypeHandleKey;

public class FieldInfo implements Comparable<FieldInfo> {

	private final String name;
	private final Method method;
	private final Field field;

	private final Class<?> fieldClass;
	private final Type fieldType;

	private final boolean isTypeHandle;

	
	
	@Override
	public String toString() {
		return "FieldInfo [name=" + name + ", method=" + method + ", field=" + field + ", fieldClass=" + fieldClass
				+ ", fieldType=" + fieldType + ", isTypeHandle=" + isTypeHandle + "]";
	}

	public FieldInfo(String name, Method method, Field field, boolean isKey) {
		this.name = name;
		this.method = method;
		this.field = field;

		this.isTypeHandle = isKey;

		if (method.getParameterTypes().length == 1) {
			this.fieldClass = method.getParameterTypes()[0];
			this.fieldType = method.getGenericParameterTypes()[0];
		} else {
			this.fieldClass = method.getReturnType();
			this.fieldType = method.getGenericReturnType();
		}
	}

	public boolean isTypeHandle() {
		return isTypeHandle;
	}

	public Class<?> getFieldClass() {
		return fieldClass;
	}

	public Type getFieldType() {
		return fieldType;
	}

	public String getName() {
		return name;
	}

	public Method getMethod() {
		return method;
	}

	public Field getField() {
		return field;
	}

	public int compareTo(FieldInfo o) {
		int i = 0;
		if (isTypeHandle) {
			return -1;
		}
		return this.name.compareTo(o.name);
	}


	public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
		T annotation = null;
		annotation = method.getAnnotation(annotationClass);

		if (annotation == null) {
			if (field != null) {
				annotation = field.getAnnotation(annotationClass);
			}
		}

		return annotation;
	}
}
