package com.meidusa.fastjson.parser.deserializer;

import java.lang.reflect.Type;
import java.util.Currency;

import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONToken;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;

public class CurrencyDeserializer implements ObjectDeserializer {
    public final static CurrencyDeserializer instance = new CurrencyDeserializer();

    @SuppressWarnings("unchecked")
    public <T> T deserialze(DefaultExtJSONParser parser, Type clazz) {
        Object value = parser.parse();

        if (value == null) {
            return null;
        }
        
        String currency = (String) value;
        
        return (T) Currency.getInstance(currency);
    }

    public int getFastMatchToken() {
        return JSONToken.LITERAL_STRING;
    }
}
