/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastbson.util;

import com.meidusa.fastbson.exception.SerializeException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TypeHelper {
    private static Class array = Object[].class;

    public static List<Class> getGenericDeserializer(Type type) {
        ArrayList<Class> typeList;
        block16: {
            typeList = new ArrayList<Class>();
            while (true) {
                if (type instanceof Class) {
                    if (((Class)type).isArray()) {
                        if (type == byte[].class) {
                            typeList.add(byte[].class);
                        } else {
                            typeList.add(array);
                            typeList.add(((Class)type).getComponentType());
                        }
                    } else {
                        typeList.add((Class)type);
                        if (Collection.class.isAssignableFrom((Class)type)) {
                            typeList.add(Object.class);
                        } else if (Map.class.isAssignableFrom((Class)type)) {
                            typeList.add(Object.class);
                        }
                    }
                    break block16;
                }
                if (type instanceof ParameterizedType) {
                    Type[] genericClass;
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Class clazz = (Class)parameterizedType.getRawType();
                    if (Collection.class.isAssignableFrom(clazz)) {
                        genericClass = ((ParameterizedType)type).getActualTypeArguments();
                        if (genericClass == null || genericClass.length != 1) {
                            throw new SerializeException.GenericTypeNotDefinedException("Collection should be given a generic type , such as Collection<Account> or Collection<String>");
                        }
                        typeList.add((Class)((ParameterizedType)type).getRawType());
                        type = genericClass[0];
                        continue;
                    }
                    if (Map.class.isAssignableFrom(clazz)) {
                        genericClass = ((ParameterizedType)type).getActualTypeArguments();
                        if (genericClass == null || genericClass.length != 2) {
                            throw new SerializeException.GenericTypeNotDefinedException("Map should be given a generic type, such as Map<String, Account>");
                        }
                        if (genericClass[0] != String.class) {
                            throw new SerializeException.WrongGenericTypeException("Map's first generic type should be String");
                        }
                        typeList.add((Class)((ParameterizedType)type).getRawType());
                        type = genericClass[1];
                        continue;
                    }
                    typeList.add((Class)((ParameterizedType)type).getRawType());
                    break block16;
                }
                if (type instanceof GenericArrayType) {
                    typeList.add(array);
                    type = ((GenericArrayType)type).getGenericComponentType();
                    continue;
                }
                if (!(type instanceof WildcardType)) break;
                typeList.add(Object.class);
            }
            throw new SerializeException.WrongGenericTypeException("wrong type" + type);
        }
        return typeList;
    }
}

