/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastbson.serializer;

import com.meidusa.fastbson.parse.BSONScanner;
import com.meidusa.fastbson.parse.BSONWriter;
import com.meidusa.fastbson.serializer.AbstractObjectSerializer;
import com.meidusa.fastbson.serializer.ObjectSerializer;
import com.meidusa.fastbson.serializer.UnknownTypeSerializer;
import java.util.HashMap;
import java.util.Map;

public abstract class MapSerializer
extends AbstractObjectSerializer {
    @Override
    public Object deserialize(BSONScanner scanner, ObjectSerializer[] subSerializer, int i) {
        ObjectSerializer subSerializerCurrent = subSerializer[i++];
        scanner.skip(4);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String name = "";
        while (scanner.readType() != 0) {
            name = scanner.readCString();
            Object o = subSerializerCurrent.deserialize(scanner, subSerializer, i);
            map.put(name, o);
        }
        return map;
    }

    @Override
    public void serialize(BSONWriter writer, Object value, ObjectSerializer[] subSerializer, int i) {
        ObjectSerializer subSerializerCurrent = subSerializer[i++];
        Map map = (Map)value;
        writer.beginObject();
        for (Map.Entry entry : map.entrySet()) {
            if (subSerializerCurrent instanceof UnknownTypeSerializer) {
                writer.write(MapSerializer.getUnknownBsonSuffix(entry.getValue()));
            } else {
                writer.write(subSerializerCurrent.getBsonSuffix());
            }
            writer.writeCString((String)entry.getKey());
            subSerializerCurrent.serialize(writer, entry.getValue(), subSerializer, i);
        }
        writer.endObject();
    }

    @Override
    public abstract Class<?> getSerializedClass();

    @Override
    public byte getBsonSuffix() {
        return 3;
    }
}

