/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastbson.serializer;

import com.meidusa.fastbson.parse.BSONScanner;
import com.meidusa.fastbson.parse.BSONWriter;
import com.meidusa.fastbson.serializer.AbstractObjectSerializer;
import com.meidusa.fastbson.serializer.ObjectSerializer;
import com.meidusa.fastbson.serializer.UnknownTypeSerializer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class ArraySerializer
extends AbstractObjectSerializer {
    @Override
    public Object deserialize(BSONScanner scanner, ObjectSerializer[] subSerializer, int i) {
        ObjectSerializer subSerializerCurrent = subSerializer[i++];
        ArrayObject arr = new ArrayObject();
        scanner.skip(4);
        arr.clazz = subSerializerCurrent.getSerializedClass();
        while (scanner.readType() != 0) {
            scanner.readCString();
            arr.add(subSerializerCurrent.deserialize(scanner, subSerializer, i));
        }
        return arr.getAll();
    }

    @Override
    public void serialize(BSONWriter writer, Object value, ObjectSerializer[] subSerializer, int i) {
        ObjectSerializer subSerializerCurrent = subSerializer[i++];
        writer.beginArray();
        int j = 0;
        while (j < Array.getLength(value)) {
            Object object = Array.get(value, j);
            if (subSerializerCurrent instanceof UnknownTypeSerializer) {
                writer.write(ArraySerializer.getUnknownBsonSuffix(object));
            } else {
                writer.write(subSerializerCurrent.getBsonSuffix());
            }
            writer.writeCString(String.valueOf(j));
            subSerializerCurrent.serialize(writer, object, subSerializer, i);
            ++j;
        }
        writer.endArray();
    }

    @Override
    public Class<?> getSerializedClass() {
        return null;
    }

    @Override
    public byte getBsonSuffix() {
        return 4;
    }

    class ArrayObject {
        Class<?> clazz;
        List<Object> list = new ArrayList<Object>();

        ArrayObject() {
        }

        void add(Object o) {
            this.list.add(o);
        }

        Object getAll() {
            Object array = Array.newInstance(this.clazz, this.list.size());
            int i = 0;
            while (i < Array.getLength(array)) {
                Array.set(array, i, this.list.get(i));
                ++i;
            }
            return array;
        }
    }
}

