/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastbson.serializer;

import com.meidusa.fastbson.serializer.ObjectSerializer;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.ClassUtils;

public abstract class AbstractObjectSerializer
implements ObjectSerializer {
    @Override
    public byte getBsonSuffix() {
        return 3;
    }

    public static byte getUnknownBsonSuffix(Object o) {
        if (o == null) {
            return 10;
        }
        Class<?> clazz = o.getClass();
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return 16;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return 18;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return 1;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return 1;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return 8;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return 16;
        }
        if (clazz == Date.class) {
            return 9;
        }
        if (clazz == String.class || clazz.isEnum()) {
            return 2;
        }
        if (clazz == byte[].class) {
            return 5;
        }
        if (clazz == BigDecimal.class) {
            return 126;
        }
        if (clazz.isArray() || ClassUtils.isAssignable(clazz, Collection.class)) {
            return 4;
        }
        return 3;
    }
}

