/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastbson;

import com.meidusa.fastbson.ASMSerializerFactory;
import com.meidusa.fastbson.SerializerGroup;
import com.meidusa.fastbson.TypeWrapper;
import com.meidusa.fastbson.parse.BSONScanner;
import com.meidusa.fastbson.parse.BSONWriter;
import com.meidusa.fastbson.parse.ByteArrayBSONWriter;
import com.meidusa.fastbson.serializer.ObjectSerializer;
import com.meidusa.fastbson.serializer.UnknownTypeSerializer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;

public class FastBsonSerializer {
    private static ThreadLocal<BSONWriter> bufferThreadLocal = new ThreadLocal();
    private static HashMap<TypeWrapper, SerializerGroup> serializerGroupMap = new HashMap();
    public static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public BSONWriter encode(Object obj) {
        BSONWriter writer = bufferThreadLocal.get();
        if (writer == null) {
            writer = new ByteArrayBSONWriter();
            bufferThreadLocal.set(writer);
        }
        writer.clear();
        ObjectSerializer serializer = UnknownTypeSerializer.getInstance();
        serializer.serialize(writer, obj, null, 0);
        return writer;
    }

    public void encode(Object obj, BSONWriter writer) {
        ObjectSerializer serializer = UnknownTypeSerializer.getInstance();
        serializer.serialize(writer, obj, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BSONWriter encode(Object obj, Type type) {
        BSONWriter writer = bufferThreadLocal.get();
        if (writer == null) {
            writer = new ByteArrayBSONWriter();
            bufferThreadLocal.set(writer);
        }
        writer.clear();
        TypeWrapper wrapper = new TypeWrapper(type);
        SerializerGroup group = serializerGroupMap.get(wrapper);
        if (group == null) {
            HashMap<TypeWrapper, SerializerGroup> hashMap = serializerGroupMap;
            synchronized (hashMap) {
                group = serializerGroupMap.get(wrapper);
                if (group == null) {
                    group = this.generateSerializerGroup(wrapper);
                    serializerGroupMap.put(wrapper, group);
                }
            }
        }
        group.serialize(writer, obj);
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(BSONScanner scanner, Type type) {
        if (type != null) {
            TypeWrapper wrapper = new TypeWrapper(type);
            SerializerGroup group = serializerGroupMap.get(wrapper);
            if (group == null) {
                HashMap<TypeWrapper, SerializerGroup> hashMap = serializerGroupMap;
                synchronized (hashMap) {
                    group = serializerGroupMap.get(wrapper);
                    if (group == null) {
                        group = this.generateSerializerGroup(wrapper);
                        serializerGroupMap.put(wrapper, group);
                    }
                }
            }
            return group.deserialize(scanner);
        }
        return this.decode(scanner);
    }

    public Object decode(BSONScanner scanner) {
        ObjectSerializer serializer = UnknownTypeSerializer.getInstance();
        return serializer.deserialize(scanner, null, 0);
    }

    public SerializerGroup generateSerializerGroup(TypeWrapper wrapper) {
        List<Class> classes = wrapper.classes;
        SerializerGroup group = new SerializerGroup();
        group.rawSerialzer = ASMSerializerFactory.getSerializer(classes.get(0));
        int subsize = 0;
        subsize = classes.size() - 1;
        if (subsize > 0) {
            ObjectSerializer[] subSerializers = new ObjectSerializer[subsize];
            int i = 0;
            while (i < subsize) {
                subSerializers[i] = ASMSerializerFactory.getSerializer(classes.get(i + 1));
                ++i;
            }
            group.subSerializers = subSerializers;
        }
        return group;
    }

    public static void registerReplace(Class<?> replaced, Class<?> replace) {
        ASMSerializerFactory.createAndReplace(replaced, replace);
    }

    public static void registerSerializer(Class<?> replaced, ObjectSerializer serializer) {
        ASMSerializerFactory.replace(replaced, serializer);
    }

    public void registerDateFormat(DateFormat format) {
        dateFormat = format;
    }
}

