/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.typeconvert.converters;

import com.meidusa.toolkit.common.util.typeconvert.ConvertChain;
import com.meidusa.toolkit.common.util.typeconvert.ConvertFailedException;
import com.meidusa.toolkit.common.util.typeconvert.Converter;

public class ShortConverter
implements Converter {
    protected static final Short DEFAULT_VALUE = new Short(0);

    @Override
    public Object convert(Object value, ConvertChain chain) {
        if (value == null) {
            throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
        }
        if (value instanceof Short) {
            return value;
        }
        if (value instanceof Number) {
            return new Short(((Number)value).shortValue());
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            try {
                return Short.decode(strValue);
            }
            catch (NumberFormatException e) {
                if (strValue.length() > 0) {
                    throw new ConvertFailedException(e);
                }
                throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
            }
        }
        return chain.convert(value);
    }
}

