/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.typeconvert.converters;

import com.meidusa.toolkit.common.util.collection.EnumerationIterator;
import com.meidusa.toolkit.common.util.typeconvert.ConvertChain;
import com.meidusa.toolkit.common.util.typeconvert.ConvertFailedException;
import com.meidusa.toolkit.common.util.typeconvert.ConvertManager;
import com.meidusa.toolkit.common.util.typeconvert.Converter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public class ObjectArrayConverter
implements Converter {
    @Override
    public Object convert(Object value, ConvertChain chain) {
        Class targetType = chain.getTargetType();
        Class<?> componentType = targetType.getComponentType();
        if (componentType == null) {
            throw new ConvertFailedException();
        }
        if (value == null) {
            throw new ConvertFailedException().setDefaultValue(Array.newInstance(componentType, 0));
        }
        if (targetType.isInstance(value)) {
            return value;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            Object convertedValues = Array.newInstance(componentType, length);
            ConvertManager manager = chain.getConvertManager();
            for (int i = 0; i < length; ++i) {
                Array.set(convertedValues, i, manager.asType(componentType, Array.get(value, i)));
            }
            return convertedValues;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            Object convertedValues = Array.newInstance(componentType, values.size());
            ConvertManager manager = chain.getConvertManager();
            Iterator iterator = values.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Array.set(convertedValues, i, manager.asType(componentType, iterator.next()));
                ++i;
            }
            return convertedValues;
        }
        Iterator iterator = null;
        if (value instanceof Iterator) {
            iterator = (Iterator)value;
        } else if (value instanceof Enumeration) {
            iterator = new EnumerationIterator((Enumeration)value);
        }
        if (iterator != null) {
            ArrayList<Object> convertedValueList = new ArrayList<Object>();
            ConvertManager manager = chain.getConvertManager();
            while (iterator.hasNext()) {
                convertedValueList.add(manager.asType(componentType, iterator.next()));
            }
            int length = convertedValueList.size();
            Object convertedValues = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(convertedValues, i, convertedValueList.get(i));
            }
            return convertedValues;
        }
        return chain.convert(value);
    }
}

