/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.typeconvert.converters;

import com.meidusa.toolkit.common.util.typeconvert.ConvertChain;
import com.meidusa.toolkit.common.util.typeconvert.ConvertFailedException;
import com.meidusa.toolkit.common.util.typeconvert.Converter;

public class ByteConverter
implements Converter {
    protected static final Byte DEFAULT_VALUE = new Byte(0);

    @Override
    public Object convert(Object value, ConvertChain chain) {
        if (value == null) {
            throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
        }
        if (value instanceof Byte) {
            return value;
        }
        if (value instanceof Number) {
            return new Byte(((Number)value).byteValue());
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            try {
                return Byte.decode(strValue);
            }
            catch (NumberFormatException e) {
                if (strValue.length() > 0) {
                    throw new ConvertFailedException(e);
                }
                throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
            }
        }
        return chain.convert(value);
    }
}

