/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.typeconvert.converters;

import com.meidusa.toolkit.common.util.typeconvert.ConvertChain;
import com.meidusa.toolkit.common.util.typeconvert.ConvertFailedException;
import com.meidusa.toolkit.common.util.typeconvert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDecimalConverter
implements Converter {
    protected static final BigDecimal DEFAULT_VALUE = new BigDecimal(BigInteger.ZERO);

    @Override
    public Object convert(Object value, ConvertChain chain) {
        if (value == null) {
            throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
        }
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString());
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            try {
                return new BigDecimal(strValue);
            }
            catch (NumberFormatException e) {
                if (strValue.length() > 0) {
                    throw new ConvertFailedException(e);
                }
                throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
            }
        }
        return chain.convert(value);
    }
}

