/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.typeconvert;

import com.meidusa.toolkit.common.util.collection.ArrayHashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeInfo {
    private static Map typeMap = Collections.synchronizedMap(new HashMap());
    private Class type;
    private Class componentType;
    private int dimension;
    private List superclasses = new ArrayList(2);
    private List interfaces = new ArrayList(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfo getTypeInfo(Class type) {
        TypeInfo typeInfo;
        if (type == null) {
            throw new NullPointerException();
        }
        Map map = typeMap;
        synchronized (map) {
            typeInfo = (TypeInfo)typeMap.get(type);
            if (typeInfo == null) {
                typeInfo = new TypeInfo(type);
                typeMap.put(type, typeInfo);
            }
        }
        return typeInfo;
    }

    private TypeInfo(Class type) {
        this.type = type;
        if (type.isArray()) {
            this.componentType = type;
            do {
                this.componentType = this.componentType.getComponentType();
                ++this.dimension;
            } while (this.componentType.isArray());
        }
        if (this.dimension > 0) {
            Class<Object> superComponentType = this.componentType.getSuperclass();
            if (superComponentType == null && !Object.class.equals((Object)this.componentType)) {
                superComponentType = Object.class;
            }
            if (superComponentType != null) {
                Class superclass = TypeInfo.getArrayClass(superComponentType, this.dimension);
                this.superclasses.add(superclass);
                this.superclasses.addAll(TypeInfo.getTypeInfo((Class)superclass).superclasses);
            } else {
                for (int i = this.dimension - 1; i >= 0; --i) {
                    this.superclasses.add(TypeInfo.getArrayClass(Object.class, i));
                }
            }
        } else {
            Class superclass = type.getSuperclass();
            if (superclass != null) {
                this.superclasses.add(superclass);
                this.superclasses.addAll(TypeInfo.getTypeInfo(superclass).superclasses);
            }
        }
        if (this.dimension == 0) {
            Class<?>[] typeInterfaces = type.getInterfaces();
            ArrayHashSet set = new ArrayHashSet();
            for (int i = 0; i < typeInterfaces.length; ++i) {
                Class typeInterface = typeInterfaces[i];
                set.add(typeInterface);
                set.addAll(TypeInfo.getTypeInfo(typeInterface).interfaces);
            }
            for (Class typeInterface : this.superclasses) {
                set.addAll(TypeInfo.getTypeInfo((Class)typeInterface).interfaces);
            }
            this.interfaces.addAll(set);
        }
    }

    public Class getType() {
        return this.type;
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public List getSuperclasses() {
        return Collections.unmodifiableList(this.superclasses);
    }

    public List getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public static Class getArrayClass(Class componentType, int dimension) {
        if (dimension == 0) {
            return componentType;
        }
        return Array.newInstance(componentType, new int[dimension]).getClass();
    }
}

