/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.typeconvert;

import com.meidusa.toolkit.common.util.enumeration.Enum;
import com.meidusa.toolkit.common.util.enumeration.EnumConverter;
import com.meidusa.toolkit.common.util.enumeration.FlagSet;
import com.meidusa.toolkit.common.util.enumeration.FlagSetConverter;
import com.meidusa.toolkit.common.util.typeconvert.ConvertChain;
import com.meidusa.toolkit.common.util.typeconvert.ConvertFailedException;
import com.meidusa.toolkit.common.util.typeconvert.Converter;
import com.meidusa.toolkit.common.util.typeconvert.Convertible;
import com.meidusa.toolkit.common.util.typeconvert.TypeInfo;
import com.meidusa.toolkit.common.util.typeconvert.converters.BigDecimalConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.BigIntegerConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.BooleanConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.ByteConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.CharacterConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.DoubleConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.FloatConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.IntegerConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.LongConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.ObjectArrayConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.ObjectConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.ShortConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.SqlDateConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.SqlTimeConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.SqlTimestampConverter;
import com.meidusa.toolkit.common.util.typeconvert.converters.StringConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ConvertManager {
    private static final Object NO_DEFAULT_VALUE = new Object();
    private Map registry = Collections.synchronizedMap(new HashMap());
    private Map aliases = Collections.synchronizedMap(new HashMap());

    public ConvertManager() {
        this.register(BigDecimal.class, new BigDecimalConverter());
        this.register(BigInteger.class, new BigIntegerConverter());
        this.register(Boolean.class, new BooleanConverter());
        this.register(Byte.class, new ByteConverter());
        this.register(Character.class, new CharacterConverter());
        this.register(Double.class, new DoubleConverter());
        this.register(Float.class, new FloatConverter());
        this.register(Integer.class, new IntegerConverter());
        this.register(Long.class, new LongConverter());
        this.register(Short.class, new ShortConverter());
        this.register(Date.class, new SqlDateConverter());
        this.register(Time.class, new SqlTimeConverter());
        this.register(Timestamp.class, new SqlTimestampConverter());
        this.register(String.class, new StringConverter());
        this.register(Object[].class, new ObjectArrayConverter());
        this.register(Object.class, new ObjectConverter());
        this.register(Enum.class, new EnumConverter());
        this.register(FlagSet.class, new FlagSetConverter());
        this.registerAlias("string", String.class);
        this.registerAlias("enum", Enum.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class type, Converter converter) {
        Map map = this.registry;
        synchronized (map) {
            if (Boolean.class.equals((Object)type) || Boolean.TYPE.equals(type)) {
                this.internalRegister(Boolean.class, converter);
                this.internalRegister(Boolean.TYPE, converter);
            } else if (Byte.class.equals((Object)type) || Byte.TYPE.equals(type)) {
                this.internalRegister(Byte.class, converter);
                this.internalRegister(Byte.TYPE, converter);
            } else if (Character.class.equals((Object)type) || Character.TYPE.equals(type)) {
                this.internalRegister(Character.class, converter);
                this.internalRegister(Character.TYPE, converter);
            } else if (Double.class.equals((Object)type) || Double.TYPE.equals(type)) {
                this.internalRegister(Double.class, converter);
                this.internalRegister(Double.TYPE, converter);
            } else if (Float.class.equals((Object)type) || Float.TYPE.equals(type)) {
                this.internalRegister(Float.class, converter);
                this.internalRegister(Float.TYPE, converter);
            } else if (Integer.class.equals((Object)type) || Integer.TYPE.equals(type)) {
                this.internalRegister(Integer.class, converter);
                this.internalRegister(Integer.TYPE, converter);
            } else if (Long.class.equals((Object)type) || Long.TYPE.equals(type)) {
                this.internalRegister(Long.class, converter);
                this.internalRegister(Long.TYPE, converter);
            } else if (Short.class.equals((Object)type) || Short.TYPE.equals(type)) {
                this.internalRegister(Short.class, converter);
                this.internalRegister(Short.TYPE, converter);
            } else {
                this.internalRegister(type, converter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAlias(String alias, Class type) {
        Map map = this.aliases;
        synchronized (map) {
            if (alias != null && type != null && !this.aliases.containsKey(alias)) {
                this.aliases.put(alias, type);
            }
        }
    }

    private void internalRegister(Class type, Converter converter) {
        LinkedList<Converter> converters = (LinkedList<Converter>)this.registry.get(type);
        if (converters == null) {
            converters = new LinkedList<Converter>();
            this.registry.put(type, converters);
        }
        if (!converters.contains(converter)) {
            converters.addFirst(converter);
            this.registerAlias(type.getName(), type);
        }
    }

    public boolean asBoolean(Object value) {
        return (Boolean)this.asType(Boolean.class, value);
    }

    public boolean asBoolean(Object value, boolean defaultValue) {
        return (Boolean)this.asType(Boolean.class, value, new Boolean(defaultValue));
    }

    public byte asByte(Object value) {
        return (Byte)this.asType(Byte.class, value);
    }

    public byte asByte(Object value, byte defaultValue) {
        return (Byte)this.asType(Byte.class, value, new Byte(defaultValue));
    }

    public char asChar(Object value) {
        return ((Character)this.asType(Character.class, value)).charValue();
    }

    public char asChar(Object value, char defaultValue) {
        return ((Character)this.asType(Character.class, value, new Character(defaultValue))).charValue();
    }

    public double asDouble(Object value) {
        return (Double)this.asType(Double.class, value);
    }

    public double asDouble(Object value, double defaultValue) {
        return (Double)this.asType(Double.class, value, new Double(defaultValue));
    }

    public float asFloat(Object value) {
        return ((Float)this.asType(Float.class, value)).floatValue();
    }

    public float asFloat(Object value, float defaultValue) {
        return ((Float)this.asType(Float.class, value, new Float(defaultValue))).floatValue();
    }

    public int asInt(Object value) {
        return (Integer)this.asType(Integer.class, value);
    }

    public int asInt(Object value, int defaultValue) {
        return (Integer)this.asType(Integer.class, value, new Integer(defaultValue));
    }

    public long asLong(Object value) {
        return (Long)this.asType(Long.class, value);
    }

    public long asLong(Object value, long defaultValue) {
        return (Long)this.asType(Long.class, value, new Long(defaultValue));
    }

    public short asShort(Object value) {
        return (Short)this.asType(Short.class, value);
    }

    public short asShort(Object value, short defaultValue) {
        return (Short)this.asType(Short.class, value, new Short(defaultValue));
    }

    public String asString(Object value) {
        return (String)this.asType(String.class, value);
    }

    public String asString(Object value, String defaultValue) {
        return (String)this.asType(String.class, value, defaultValue);
    }

    public Object asType(Object targetType, Object value) {
        return this.asType(targetType, value, NO_DEFAULT_VALUE);
    }

    public Object asType(Object targetType, Object value, Object defaultValue) {
        try {
            return new ChainImpl(this, this.getTargetType(targetType)).convert(value);
        }
        catch (ConvertFailedException e) {
            if (e.isDefaultValueSet()) {
                return defaultValue == NO_DEFAULT_VALUE ? e.getDefaultValue() : defaultValue;
            }
            throw e;
        }
    }

    public Object asTypeWithoutDefaultValue(Object targetType, Object value) {
        return new ChainImpl(this, this.getTargetType(targetType)).convert(value);
    }

    private Class getTargetType(Object targetType) {
        Class type;
        if (targetType instanceof Class) {
            return (Class)targetType;
        }
        if (targetType instanceof String && (type = (Class)this.aliases.get(targetType)) != null) {
            return type;
        }
        throw new IllegalArgumentException("Invalid targetType " + targetType);
    }

    private class ChainImpl
    implements ConvertChain {
        private static final int STATE_START = 0;
        private static final int STATE_TARGET_TYPE = 1;
        private static final int STATE_BASE_TYPE = 2;
        private static final int STATE_INTERFACE = 3;
        private static final int STATE_OBJECT = 4;
        private static final int STATE_END = 5;
        private final ConvertManager manager;
        private final TypeInfo targetTypeInfo;
        private int state = 0;
        private Convertible previousConvertibleValue;
        private Iterator converterIterator;
        private Iterator superclassIterator;
        private Iterator interfaceIterator;

        ChainImpl(ConvertManager manager, Class targetType) {
            this.manager = manager;
            this.targetTypeInfo = TypeInfo.getTypeInfo(targetType);
        }

        @Override
        public ConvertManager getConvertManager() {
            return this.manager;
        }

        @Override
        public Class getTargetType() {
            return this.targetTypeInfo.getType();
        }

        @Override
        public Object convert(Object value) {
            Converter converter;
            Class targetType = this.targetTypeInfo.getType();
            if (value instanceof Convertible && !value.equals(this.previousConvertibleValue) && (converter = ((Convertible)value).getConverter(targetType)) != null) {
                this.previousConvertibleValue = (Convertible)value;
                return converter.convert(value, this);
            }
            if (this.state == 0) {
                ++this.state;
                this.converterIterator = this.getConverterIterator(targetType);
            }
            if (this.state == 1 && !this.hasNext(this.converterIterator)) {
                ++this.state;
                this.superclassIterator = this.targetTypeInfo.getSuperclasses().iterator();
                this.converterIterator = this.getSuperclassConverterIterator();
            }
            if (this.state == 2 && !this.hasNext(this.converterIterator)) {
                this.converterIterator = this.getSuperclassConverterIterator();
                if (!this.hasNext(this.converterIterator)) {
                    ++this.state;
                    this.interfaceIterator = this.targetTypeInfo.getInterfaces().iterator();
                    this.converterIterator = this.getInterfaceConverterIterator();
                }
            }
            if (this.state == 3 && !this.hasNext(this.converterIterator)) {
                this.converterIterator = this.getInterfaceConverterIterator();
                if (!this.hasNext(this.converterIterator)) {
                    ++this.state;
                    if (!Object.class.equals((Object)this.targetTypeInfo.getType())) {
                        this.converterIterator = this.getConverterIterator(Object.class);
                    }
                }
            }
            if (this.state == 4 && !this.hasNext(this.converterIterator)) {
                ++this.state;
            }
            if (this.state != 5) {
                converter = (Converter)this.converterIterator.next();
                return converter.convert(value, this);
            }
            throw new ConvertFailedException();
        }

        private Iterator getConverterIterator(Class type) {
            LinkedList converters = (LinkedList)ConvertManager.this.registry.get(type);
            if (converters != null && converters.size() > 0) {
                return converters.iterator();
            }
            return null;
        }

        private Iterator getSuperclassConverterIterator() {
            Iterator iterator = null;
            while (this.superclassIterator.hasNext()) {
                Class superclass = (Class)this.superclassIterator.next();
                if (superclass.equals(Object.class) || !this.hasNext(iterator = this.getConverterIterator(superclass))) continue;
                return iterator;
            }
            return null;
        }

        private Iterator getInterfaceConverterIterator() {
            Iterator iterator = null;
            while (this.interfaceIterator.hasNext()) {
                iterator = this.getConverterIterator((Class)this.interfaceIterator.next());
                if (!this.hasNext(iterator)) continue;
                return iterator;
            }
            return null;
        }

        private boolean hasNext(Iterator iterator) {
            return iterator != null && iterator.hasNext();
        }
    }
}

