/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.resourcebundle.xml;

import com.meidusa.toolkit.common.util.resourcebundle.AbstractResourceBundleFactory;
import com.meidusa.toolkit.common.util.resourcebundle.ResourceBundle;
import com.meidusa.toolkit.common.util.resourcebundle.ResourceBundleCreateException;
import com.meidusa.toolkit.common.util.resourcebundle.ResourceBundleLoader;
import com.meidusa.toolkit.common.util.resourcebundle.xml.XMLResourceBundle;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class XMLResourceBundleFactory
extends AbstractResourceBundleFactory {
    public XMLResourceBundleFactory() {
    }

    public XMLResourceBundleFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    public XMLResourceBundleFactory(ResourceBundleLoader loader) {
        super(loader);
    }

    @Override
    protected String getFilename(String bundleName) {
        return super.getFilename(bundleName) + ".xml";
    }

    @Override
    protected ResourceBundle parse(InputStream stream, String systemId) throws ResourceBundleCreateException {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(stream, systemId);
            return new XMLResourceBundle(doc);
        }
        catch (DocumentException e) {
            throw new ResourceBundleCreateException("Failed to read XML document \"{0}\"", new Object[]{systemId}, e);
        }
    }
}

