/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.resourcebundle;

import com.meidusa.toolkit.common.util.MissingResourceException;
import com.meidusa.toolkit.common.util.SoftCache;
import com.meidusa.toolkit.common.util.StringUtil;
import com.meidusa.toolkit.common.util.resourcebundle.AbstractXmlProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class XmlPropertiesFactory {
    private static SoftCache cache = new SoftCache();

    private XmlPropertiesFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(Class clazz) {
        Properties properties = XmlPropertiesFactory.getProperties(clazz, Locale.getDefault());
        if (properties == null) {
            properties = XmlPropertiesFactory.getProperties(clazz, null);
        }
        if (properties == null) {
            SoftCache softCache = cache;
            synchronized (softCache) {
                properties = XmlPropertiesFactory.getProperties(clazz, Locale.getDefault());
                if (properties == null) {
                    properties = XmlPropertiesFactory.getProperties(clazz, null);
                }
                if (properties == null) {
                    properties = XmlPropertiesFactory.loadPropertiesFromXML(clazz, Locale.getDefault());
                    int hash = XmlPropertiesFactory.getHash(clazz, Locale.getDefault());
                    cache.put((Object)hash, properties);
                    return properties;
                }
                return properties;
            }
        }
        return properties;
    }

    public static void loadProperties(AbstractXmlProperties properties) {
        Properties props = XmlPropertiesFactory.getProperties(properties.getClass());
        properties.putAll((Map<?, ?>)props);
    }

    private static int getHash(Object clazz, Locale locale) {
        int hash = clazz.hashCode();
        if (locale != null) {
            hash ^= locale.hashCode();
        }
        return hash;
    }

    private static Properties getProperties(Object object, Locale locale) {
        int hash = XmlPropertiesFactory.getHash(object, locale);
        return (Properties)cache.get(hash);
    }

    private static synchronized Properties loadPropertiesFromXML(Class clazz, Locale locale) {
        StringBuffer buffer = new StringBuffer(clazz.getSimpleName());
        String base = buffer.toString() + ".xml";
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!StringUtil.isEmpty(locale.getLanguage())) {
            buffer.append("_");
            buffer.append(locale.getLanguage());
        }
        String language = buffer.toString() + ".xml";
        if (!StringUtil.isEmpty(locale.getCountry())) {
            buffer.append("_");
            buffer.append(locale.getCountry());
        }
        String country = buffer.toString() + ".xml";
        InputStream in = null;
        if (!StringUtil.isEmpty(locale.getCountry())) {
            in = clazz.getResourceAsStream(country);
        }
        if (in == null && !StringUtil.isEmpty(locale.getLanguage())) {
            in = clazz.getResourceAsStream(language);
        }
        if (in == null) {
            in = clazz.getResourceAsStream(base);
        }
        if (in != null) {
            Properties properties = new Properties();
            try {
                properties.loadFromXML(in);
            }
            catch (IOException e) {
                XmlPropertiesFactory.throwMissingResourceException(clazz.getName(), locale, e);
            }
            return properties;
        }
        XmlPropertiesFactory.throwMissingResourceException(clazz.getName(), locale, null);
        return null;
    }

    private static void throwMissingResourceException(String baseName, Locale locale, Throwable e) throws MissingResourceException {
        throw new MissingResourceException("Can't find bundle for base name " + baseName + ", locale " + locale, baseName + "_" + locale, "", e);
    }
}

