/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.regex;

import com.meidusa.toolkit.common.util.collection.Predicate;
import com.meidusa.toolkit.common.util.regex.MatchItem;
import com.meidusa.toolkit.common.util.regex.MatchPattern;
import java.util.Collection;
import java.util.Collections;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;

public class MatchContext {
    private PatternMatcher matcher;
    private PatternMatcherInput input;
    private Substitution substitution;
    private MatchItem lastMatchItem;

    public MatchContext(String input) {
        this.init(input);
    }

    public void init(String input) {
        if (this.matcher == null) {
            this.matcher = this.createPatternMatcher();
        }
        if (this.input == null) {
            this.input = new PatternMatcherInput(input);
        } else {
            this.input.setInput(input);
        }
    }

    public Collection getPatterns() {
        return Collections.EMPTY_LIST;
    }

    public Predicate getPredicate() {
        return null;
    }

    public PatternMatcherInput getInput() {
        return this.input;
    }

    public PatternMatcherInput getInputReset() {
        this.input.setCurrentOffset(this.input.getBeginOffset());
        return this.input;
    }

    public PatternMatcher getMatcher() {
        return this.matcher;
    }

    public void setLastMatchItem(MatchItem item) {
        this.lastMatchItem = item;
    }

    public MatchItem getLastMatchItem() {
        return this.lastMatchItem;
    }

    public Substitution getSubstitution(String substitution) {
        this.substitution = this.createSubstitution(this.substitution, substitution);
        return this.substitution;
    }

    protected PatternMatcher createPatternMatcher() {
        return new Perl5Matcher();
    }

    protected Substitution createSubstitution(Substitution reuse, String substitution) {
        if (reuse == null) {
            return new Perl5Substitution(substitution);
        }
        ((Perl5Substitution)reuse).setSubstitution(substitution);
        return reuse;
    }

    protected MatchItem createMatchItem(MatchPattern pattern, MatchResult result) {
        return new MatchItem(this, pattern, result);
    }
}

