/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.exception;

import com.meidusa.toolkit.common.util.exception.ChainedThrowable;
import com.meidusa.toolkit.common.util.exception.ChainedThrowableDelegate;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ExceptionHelper {
    private static final String STRING_EXCEPTION_MESSAGE = ": ";
    private static final String STRING_CAUSED_BY = "Caused by: ";
    private static final String STRING_MORE_PREFIX = "\t... ";
    private static final String STRING_MORE_SUFFIX = " more";
    private static final String STRING_STACK_TRACE_PREFIX = "\tat ";
    private static final String STRING_CR = "\r";
    private static final String STRING_LF = "\n";
    private static final String GET_STACK_TRACE_METHOD_NAME = "getStackTrace";
    private static Method GET_STACK_TRACE_METHOD;

    private static Throwable getThrowable(ChainedThrowable throwable) {
        if (throwable instanceof ChainedThrowableDelegate) {
            return ((ChainedThrowableDelegate)throwable).delegatedThrowable;
        }
        return (Throwable)((Object)throwable);
    }

    public static ChainedThrowable getChainedThrowable(Throwable throwable) {
        if (throwable != null && !(throwable instanceof ChainedThrowable)) {
            return new ChainedThrowableDelegate(throwable);
        }
        return (ChainedThrowable)((Object)throwable);
    }

    public static ChainedThrowable getChainedThrowableCause(ChainedThrowable throwable) {
        return ExceptionHelper.getChainedThrowable(throwable.getCause());
    }

    public static void printStackTrace(ChainedThrowable throwable) {
        ExceptionHelper.printStackTrace(throwable, System.err);
    }

    public static void printStackTrace(ChainedThrowable throwable, PrintStream stream) {
        ExceptionHelper.printStackTrace(throwable, new PrintWriter(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTrace(ChainedThrowable throwable, PrintWriter writer) {
        PrintWriter printWriter = writer;
        synchronized (printWriter) {
            String[] currentStack = ExceptionHelper.analyzeStackTrace(throwable);
            ExceptionHelper.printThrowableMessage(throwable, writer, false);
            for (int i = 0; i < currentStack.length; ++i) {
                writer.println(currentStack[i]);
            }
            ExceptionHelper.printStackTraceRecursive(throwable, writer, currentStack);
            writer.flush();
        }
    }

    private static void printStackTraceRecursive(ChainedThrowable throwable, PrintWriter writer, String[] currentStack) {
        ChainedThrowable cause = ExceptionHelper.getChainedThrowableCause(throwable);
        if (cause != null) {
            int j;
            String[] causeStack = ExceptionHelper.analyzeStackTrace(cause);
            int i = currentStack.length - 1;
            for (j = causeStack.length - 1; i >= 0 && j >= 0 && currentStack[i].equals(causeStack[j]); --i, --j) {
            }
            ExceptionHelper.printThrowableMessage(cause, writer, true);
            for (i = 0; i <= j; ++i) {
                writer.println(causeStack[i]);
            }
            if (j < causeStack.length - 1) {
                writer.println(STRING_MORE_PREFIX + (causeStack.length - j - 1) + STRING_MORE_SUFFIX);
            }
            ExceptionHelper.printStackTraceRecursive(cause, writer, causeStack);
        }
    }

    private static void printThrowableMessage(ChainedThrowable throwable, PrintWriter writer, boolean cause) {
        StringBuffer buffer = new StringBuffer();
        if (cause) {
            buffer.append(STRING_CAUSED_BY);
        }
        Throwable t = ExceptionHelper.getThrowable(throwable);
        buffer.append(t.getClass().getName());
        String message = t.getMessage();
        if (message != null) {
            buffer.append(STRING_EXCEPTION_MESSAGE).append(message);
        }
        writer.println(buffer.toString());
    }

    private static String[] analyzeStackTrace(ChainedThrowable throwable) {
        if (GET_STACK_TRACE_METHOD != null) {
            Throwable t = ExceptionHelper.getThrowable(throwable);
            try {
                Object[] stackTrace = (Object[])GET_STACK_TRACE_METHOD.invoke((Object)t, new Object[0]);
                String[] list = new String[stackTrace.length];
                for (int i = 0; i < stackTrace.length; ++i) {
                    list[i] = STRING_STACK_TRACE_PREFIX + stackTrace[i];
                }
                return list;
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return new StackTraceAnalyzer(throwable).getLines();
    }

    static {
        try {
            GET_STACK_TRACE_METHOD = Throwable.class.getMethod(GET_STACK_TRACE_METHOD_NAME, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private static class StackTraceAnalyzer {
        private Throwable throwable;
        private String message;
        private StackTraceEntry currentEntry;
        private StackTraceEntry selectedEntry;
        private StackTraceEntry entry;

        StackTraceAnalyzer(ChainedThrowable throwable) {
            this.selectedEntry = this.currentEntry = new StackTraceEntry();
            this.throwable = ExceptionHelper.getThrowable(throwable);
            this.message = this.throwable.getMessage();
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            throwable.printCurrentStackTrace(pw);
            String stackTraceDump = writer.toString();
            int p = 0;
            int i = -1;
            int j = -1;
            int k = -1;
            while (p < stackTraceDump.length()) {
                int q;
                boolean includesMessage = false;
                int s = p;
                if (i == -1 && this.message != null) {
                    i = stackTraceDump.indexOf(this.message, p);
                }
                if (j == -1) {
                    j = stackTraceDump.indexOf(ExceptionHelper.STRING_CR, p);
                }
                if (k == -1) {
                    k = stackTraceDump.indexOf(ExceptionHelper.STRING_LF, p);
                }
                if (!(i == -1 || j != -1 && i > j || k != -1 && i > k)) {
                    includesMessage = true;
                    p = i + this.message.length();
                    i = -1;
                    if (j < p) {
                        j = -1;
                    }
                    if (k < p) {
                        k = -1;
                    }
                }
                if (j != -1 && (k == -1 || j < k)) {
                    p = j + 1;
                    if (p < stackTraceDump.length() && stackTraceDump.charAt(p) == ExceptionHelper.STRING_LF.charAt(0)) {
                        ++p;
                    }
                    this.addLine(stackTraceDump.substring(s, j), includesMessage);
                    j = -1;
                    if (k >= p) continue;
                    k = -1;
                    continue;
                }
                if (k != -1) {
                    q = k + 1;
                    this.addLine(stackTraceDump.substring(s, k), includesMessage);
                    p = q;
                    k = -1;
                    continue;
                }
                q = stackTraceDump.length();
                if (p + 1 >= q) continue;
                this.addLine(stackTraceDump.substring(s), includesMessage);
                p = q;
            }
            if (this.currentEntry.compareTo(this.selectedEntry) < 0) {
                this.selectedEntry = this.currentEntry;
            }
        }

        private void addLine(String line, boolean includesMessage) {
            StackTraceEntry nextEntry = this.currentEntry.accept(line, includesMessage);
            if (nextEntry != null) {
                if (this.currentEntry.compareTo(this.selectedEntry) < 0) {
                    this.selectedEntry = this.currentEntry;
                }
                this.currentEntry = nextEntry;
            }
        }

        String[] getLines() {
            return this.selectedEntry.lines.toArray(new String[this.selectedEntry.lines.size()]);
        }

        private class StackTraceEntry
        implements Comparable {
            private List lines = new ArrayList(10);
            private int includesMessage = 0;
            private int includesThrowable = 0;
            private int count = 0;

            private StackTraceEntry() {
            }

            StackTraceEntry accept(String line, boolean includesMessage) {
                if (line.startsWith(ExceptionHelper.STRING_STACK_TRACE_PREFIX)) {
                    this.lines.add(line);
                    ++this.count;
                    return null;
                }
                if (this.count > 0) {
                    StackTraceEntry newEntry = new StackTraceEntry();
                    newEntry.accept(line, includesMessage);
                    return newEntry;
                }
                if (includesMessage) {
                    this.includesMessage = 1;
                }
                if (line.indexOf(StackTraceAnalyzer.this.throwable.getClass().getName()) != -1) {
                    this.includesThrowable = 1;
                }
                return null;
            }

            public int compareTo(Object o) {
                StackTraceEntry otherEntry = (StackTraceEntry)o;
                int thisWeight = this.includesMessage + this.includesThrowable;
                int otherWeight = otherEntry.includesMessage + otherEntry.includesThrowable;
                if (thisWeight == otherWeight) {
                    return this.count - otherEntry.count;
                }
                return otherWeight - thisWeight;
            }
        }
    }
}

