/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.exception;

import com.meidusa.toolkit.common.util.exception.ChainedThrowable;
import com.meidusa.toolkit.common.util.exception.ExceptionHelper;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.SQLException;

public class ChainedThrowableDelegate
implements ChainedThrowable {
    private static final long serialVersionUID = 6847759975589708959L;
    protected static final Throwable NO_CAUSE = new Throwable();
    private static final String[] CAUSE_METHOD_NAMES = new String[]{"getNested", "getNestedException", "getNextException", "getTargetException", "getException", "getSourceException", "getCausedByException", "getRootCause", "getCause"};
    private static final String[] CAUSE_FIELD_NAMES = new String[]{"detail"};
    protected Throwable delegatedThrowable;

    public ChainedThrowableDelegate(Throwable throwable) {
        this.delegatedThrowable = throwable;
    }

    @Override
    public Throwable getCause() {
        Throwable cause = this.getCauseByWellKnownTypes(this.delegatedThrowable);
        Class<?> throwableClass = this.delegatedThrowable.getClass();
        while (cause == null && Throwable.class.isAssignableFrom(throwableClass)) {
            int i;
            for (i = 0; cause == null && i < CAUSE_METHOD_NAMES.length; ++i) {
                cause = this.getCauseByMethodName(this.delegatedThrowable, throwableClass, CAUSE_METHOD_NAMES[i]);
            }
            for (i = 0; cause == null && i < CAUSE_FIELD_NAMES.length; ++i) {
                cause = this.getCauseByFieldName(this.delegatedThrowable, throwableClass, CAUSE_FIELD_NAMES[i]);
            }
            throwableClass = throwableClass.getSuperclass();
        }
        if (cause == this.delegatedThrowable) {
            cause = null;
        }
        if (cause == NO_CAUSE) {
            return null;
        }
        return cause;
    }

    protected Throwable getCauseByWellKnownTypes(Throwable throwable) {
        Throwable cause = null;
        boolean isWellKnownType = false;
        if (throwable instanceof ChainedThrowable) {
            isWellKnownType = true;
            cause = ((ChainedThrowable)((Object)throwable)).getCause();
        } else if (throwable instanceof SQLException) {
            isWellKnownType = true;
            cause = ((SQLException)throwable).getNextException();
        } else if (throwable instanceof InvocationTargetException) {
            isWellKnownType = true;
            cause = ((InvocationTargetException)throwable).getTargetException();
        } else if (throwable instanceof RemoteException) {
            isWellKnownType = true;
            cause = ((RemoteException)throwable).detail;
        }
        if (isWellKnownType && cause == null) {
            return NO_CAUSE;
        }
        return cause;
    }

    protected Throwable getCauseByMethodName(Throwable throwable, Class throwableClass, String methodName) {
        Method method = null;
        try {
            method = throwableClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            Throwable cause = null;
            try {
                cause = (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException ignored) {
            }
            catch (InvocationTargetException ignored) {
                // empty catch block
            }
            if (cause == null) {
                return NO_CAUSE;
            }
            return cause;
        }
        return null;
    }

    protected Throwable getCauseByFieldName(Throwable throwable, Class throwableClass, String fieldName) {
        Field field = null;
        try {
            field = throwableClass.getField(fieldName);
        }
        catch (NoSuchFieldException ignored) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            Throwable cause = null;
            try {
                cause = (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException ignored) {
                // empty catch block
            }
            if (cause == null) {
                return NO_CAUSE;
            }
            return cause;
        }
        return null;
    }

    @Override
    public void printStackTrace() {
        ExceptionHelper.printStackTrace(this);
    }

    @Override
    public void printStackTrace(PrintStream stream) {
        ExceptionHelper.printStackTrace((ChainedThrowable)this, stream);
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        ExceptionHelper.printStackTrace((ChainedThrowable)this, writer);
    }

    @Override
    public void printCurrentStackTrace(PrintWriter writer) {
        if (this.delegatedThrowable instanceof ChainedThrowable) {
            ((ChainedThrowable)((Object)this.delegatedThrowable)).printCurrentStackTrace(writer);
        } else {
            this.delegatedThrowable.printStackTrace(writer);
        }
    }
}

