/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.enumeration;

import com.meidusa.toolkit.common.util.enumeration.FlagSet;
import com.meidusa.toolkit.common.util.enumeration.Flags;
import com.meidusa.toolkit.common.util.enumeration.LongEnum;
import java.text.MessageFormat;

public abstract class LongFlagSet
extends FlagSet {
    private static final long serialVersionUID = -7159161922846089638L;
    private long value;

    public LongFlagSet(Class enumClass) {
        super(enumClass);
        if (!LongEnum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Class \"{0}\" is not a subclass of \"{1}\"", enumClass.getName(), LongEnum.class.getName()));
        }
    }

    @Override
    public void setValue(Object value) {
        this.checkImmutable();
        if (value == null) {
            throw new NullPointerException("FlagSet value must not be null");
        }
        this.value = (Long)value;
    }

    @Override
    public Object getValue() {
        return new Long(this.value);
    }

    @Override
    public Flags clear() {
        this.checkImmutable();
        this.value = 0L;
        return this;
    }

    @Override
    public boolean test(Flags flags) {
        return (this.value & this.getFlagsValue(flags)) != 0L;
    }

    @Override
    public boolean testAll(Flags flags) {
        long testValue = this.getFlagsValue(flags);
        return (this.value & testValue) == testValue;
    }

    @Override
    public Flags and(Flags flags) {
        LongFlagSet flagSet = (LongFlagSet)this.getFlagSetForModification();
        flagSet.value &= this.getFlagsValue(flags);
        return flagSet;
    }

    @Override
    public Flags andNot(Flags flags) {
        LongFlagSet flagSet = (LongFlagSet)this.getFlagSetForModification();
        flagSet.value &= this.getFlagsValue(flags) ^ 0xFFFFFFFFFFFFFFFFL;
        return flagSet;
    }

    @Override
    public Flags or(Flags flags) {
        LongFlagSet flagSet = (LongFlagSet)this.getFlagSetForModification();
        flagSet.value |= this.getFlagsValue(flags);
        return flagSet;
    }

    @Override
    public Flags xor(Flags flags) {
        LongFlagSet flagSet = (LongFlagSet)this.getFlagSetForModification();
        flagSet.value ^= this.getFlagsValue(flags);
        return flagSet;
    }

    private long getFlagsValue(Flags flags) {
        this.checkFlags(flags);
        return flags instanceof LongEnum ? ((LongEnum)((Object)flags)).longValue() : ((LongFlagSet)flags).value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public String toHexString() {
        return Long.toHexString(this.value);
    }

    @Override
    public String toOctalString() {
        return Long.toOctalString(this.value);
    }

    @Override
    public String toBinaryString() {
        return Long.toBinaryString(this.value);
    }
}

