/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.enumeration;

import com.meidusa.toolkit.common.util.enumeration.Enum;

public abstract class LongEnum
extends Enum {
    private static final long serialVersionUID = 8152633183977823349L;

    protected LongEnum(String name) {
        super(name);
    }

    protected LongEnum(String name, long value) {
        super(name, new Long(value));
    }

    protected static Object createEnumType() {
        return new Enum.EnumType(){

            @Override
            protected Class getUnderlyingClass() {
                return Long.class;
            }

            @Override
            protected Object getNextValue(Object value, boolean flagMode) {
                if (value == null) {
                    return flagMode ? new Long(1L) : new Long(0L);
                }
                long longValue = (Long)value;
                if (flagMode) {
                    return new Long(longValue << 1);
                }
                return new Long(longValue + 1L);
            }

            @Override
            protected boolean isZero(Object value) {
                return (Long)value == 0L;
            }

            @Override
            protected boolean isPowerOfTwo(Object value) {
                long longValue = (Long)value;
                if (longValue == 0L) {
                    return false;
                }
                while ((longValue & 1L) == 0L) {
                    longValue >>>= 1;
                }
                return longValue == 1L;
            }
        };
    }

    @Override
    public int intValue() {
        return ((Long)this.getValue()).intValue();
    }

    @Override
    public long longValue() {
        return (Long)this.getValue();
    }

    @Override
    public double doubleValue() {
        return ((Long)this.getValue()).doubleValue();
    }

    @Override
    public float floatValue() {
        return ((Long)this.getValue()).floatValue();
    }

    @Override
    public String toHexString() {
        return Long.toHexString(((Long)this.getValue()).intValue());
    }

    @Override
    public String toOctalString() {
        return Long.toOctalString(((Long)this.getValue()).intValue());
    }

    @Override
    public String toBinaryString() {
        return Long.toBinaryString(((Long)this.getValue()).intValue());
    }
}

