/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.enumeration;

import com.meidusa.toolkit.common.util.enumeration.FlagSet;
import com.meidusa.toolkit.common.util.enumeration.Flags;
import com.meidusa.toolkit.common.util.enumeration.IntegerEnum;
import java.text.MessageFormat;

public abstract class IntegerFlagSet
extends FlagSet {
    private static final long serialVersionUID = 397018141070555601L;
    private int value;

    public IntegerFlagSet(Class enumClass) {
        super(enumClass);
        if (!IntegerEnum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Class \"{0}\" is not a subclass of \"{1}\"", enumClass.getName(), IntegerEnum.class.getName()));
        }
    }

    @Override
    public void setValue(Object value) {
        this.checkImmutable();
        if (value == null) {
            throw new NullPointerException("FlagSet value must not be null");
        }
        this.value = (Integer)value;
    }

    @Override
    public Object getValue() {
        return new Integer(this.value);
    }

    @Override
    public Flags clear() {
        this.checkImmutable();
        this.value = 0;
        return this;
    }

    @Override
    public boolean test(Flags flags) {
        return (this.value & this.getFlagsValue(flags)) != 0;
    }

    @Override
    public boolean testAll(Flags flags) {
        int testValue = this.getFlagsValue(flags);
        return (this.value & testValue) == testValue;
    }

    @Override
    public Flags and(Flags flags) {
        IntegerFlagSet flagSet = (IntegerFlagSet)this.getFlagSetForModification();
        flagSet.value &= this.getFlagsValue(flags);
        return flagSet;
    }

    @Override
    public Flags andNot(Flags flags) {
        IntegerFlagSet flagSet = (IntegerFlagSet)this.getFlagSetForModification();
        flagSet.value &= ~this.getFlagsValue(flags);
        return flagSet;
    }

    @Override
    public Flags or(Flags flags) {
        IntegerFlagSet flagSet = (IntegerFlagSet)this.getFlagSetForModification();
        flagSet.value |= this.getFlagsValue(flags);
        return flagSet;
    }

    @Override
    public Flags xor(Flags flags) {
        IntegerFlagSet flagSet = (IntegerFlagSet)this.getFlagSetForModification();
        flagSet.value ^= this.getFlagsValue(flags);
        return flagSet;
    }

    private int getFlagsValue(Flags flags) {
        this.checkFlags(flags);
        return flags instanceof IntegerEnum ? ((IntegerEnum)((Object)flags)).intValue() : ((IntegerFlagSet)flags).value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public String toHexString() {
        return Integer.toHexString(this.value);
    }

    @Override
    public String toOctalString() {
        return Integer.toOctalString(this.value);
    }

    @Override
    public String toBinaryString() {
        return Integer.toBinaryString(this.value);
    }
}

