/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.enumeration;

import com.meidusa.toolkit.common.util.enumeration.Enum;

public abstract class IntegerEnum
extends Enum {
    private static final long serialVersionUID = 343392921439669443L;

    protected IntegerEnum(String name) {
        super(name);
    }

    protected IntegerEnum(String name, int value) {
        super(name, new Integer(value));
    }

    protected static Object createEnumType() {
        return new Enum.EnumType(){

            @Override
            protected Class getUnderlyingClass() {
                return Integer.class;
            }

            @Override
            protected Object getNextValue(Object value, boolean flagMode) {
                if (value == null) {
                    return flagMode ? new Integer(1) : new Integer(0);
                }
                int intValue = (Integer)value;
                if (flagMode) {
                    return new Integer(intValue << 1);
                }
                return new Integer(intValue + 1);
            }

            @Override
            protected boolean isZero(Object value) {
                return (Integer)value == 0;
            }

            @Override
            protected boolean isPowerOfTwo(Object value) {
                int intValue = (Integer)value;
                if (intValue == 0) {
                    return false;
                }
                while ((intValue & 1) == 0) {
                    intValue >>>= 1;
                }
                return intValue == 1;
            }
        };
    }

    @Override
    public int intValue() {
        return (Integer)this.getValue();
    }

    @Override
    public long longValue() {
        return ((Integer)this.getValue()).longValue();
    }

    @Override
    public double doubleValue() {
        return ((Integer)this.getValue()).doubleValue();
    }

    @Override
    public float floatValue() {
        return ((Integer)this.getValue()).floatValue();
    }

    @Override
    public String toHexString() {
        return Integer.toHexString((Integer)this.getValue());
    }

    @Override
    public String toOctalString() {
        return Integer.toOctalString((Integer)this.getValue());
    }

    @Override
    public String toBinaryString() {
        return Integer.toBinaryString((Integer)this.getValue());
    }
}

