/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.enumeration;

import com.meidusa.toolkit.common.util.enumeration.FlagSet;
import com.meidusa.toolkit.common.util.typeconvert.ConvertChain;
import com.meidusa.toolkit.common.util.typeconvert.ConvertFailedException;
import com.meidusa.toolkit.common.util.typeconvert.Converter;

public class FlagSetConverter
implements Converter {
    @Override
    public Object convert(Object value, ConvertChain chain) {
        Class targetType = chain.getTargetType();
        if (targetType.isInstance(value)) {
            return value;
        }
        if (!FlagSet.class.isAssignableFrom(targetType)) {
            return chain.convert(value);
        }
        FlagSet flagSet = null;
        try {
            flagSet = (FlagSet)targetType.newInstance();
        }
        catch (Exception e) {
            return new ConvertFailedException();
        }
        try {
            Object flagSetValue = chain.getConvertManager().asTypeWithoutDefaultValue(flagSet.getUnderlyingClass(), value);
            flagSet.setValue(flagSetValue);
        }
        catch (ConvertFailedException e) {
            if (e.isDefaultValueSet()) {
                flagSet.setValue(e.getDefaultValue());
                throw new ConvertFailedException(e).setDefaultValue(flagSet);
            }
            return chain.convert(value);
        }
        return flagSet;
    }
}

