/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.enumeration;

import com.meidusa.toolkit.common.util.enumeration.Enum;
import com.meidusa.toolkit.common.util.enumeration.Flags;
import com.meidusa.toolkit.common.util.typeconvert.ConvertChain;
import com.meidusa.toolkit.common.util.typeconvert.Converter;
import com.meidusa.toolkit.common.util.typeconvert.Convertible;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Iterator;

public abstract class FlagSet
implements Flags,
Cloneable,
Comparable,
Serializable,
Convertible {
    private static final long serialVersionUID = -5507969553098965333L;
    private final Class enumClass;
    protected transient boolean immutable;

    public FlagSet(Class enumClass) {
        this.enumClass = enumClass;
        if (!Enum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Class \"{0}\" is not a subclass of \"{1}\"", enumClass.getName(), Enum.class.getName()));
        }
        if (!Flags.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Class \"{0}\" is not an implementation of \"{1}\"", enumClass.getName(), Flags.class.getName()));
        }
    }

    public Class getEnumClass() {
        return this.enumClass;
    }

    public Class getUnderlyingClass() {
        return Enum.getUnderlyingClass(this.enumClass);
    }

    public abstract void setValue(Object var1);

    @Override
    public abstract Object getValue();

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public Converter getConverter(Class targetType) {
        return new Converter(){

            @Override
            public Object convert(Object value, ConvertChain chain) {
                FlagSet flagSet = (FlagSet)value;
                Class targetType = chain.getTargetType();
                if (String.class.equals((Object)targetType)) {
                    return flagSet.toString();
                }
                return chain.convert(flagSet.getValue());
            }
        };
    }

    public Object clone() {
        FlagSet flagSet = null;
        try {
            flagSet = (FlagSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(MessageFormat.format("Clone not supported by class \"{0}\"", this.getClass().getName()));
        }
        flagSet.immutable = false;
        return flagSet;
    }

    public int compareTo(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            throw new IllegalArgumentException(MessageFormat.format("Could not compare object of \"{0}\" with object of \"{1}\"", this.getClass().getName(), other.getClass().getName()));
        }
        FlagSet otherFlagSet = (FlagSet)other;
        if (!this.enumClass.equals(otherFlagSet.enumClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Could not compare FlagSet of underlying class \"{0}\" with FlagSet of underlying class \"{1}\"", this.enumClass.getName(), otherFlagSet.enumClass.getName()));
        }
        return ((Comparable)this.getValue()).compareTo(otherFlagSet.getValue());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass()) || !this.enumClass.equals(((FlagSet)obj).enumClass)) {
            return false;
        }
        return this.getValue().equals(((FlagSet)obj).getValue());
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.enumClass.hashCode() ^ this.getValue().hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        String sep = "";
        Iterator i = Enum.iterator(this.enumClass);
        while (i.hasNext()) {
            Flags flags = (Flags)i.next();
            if (!this.test(flags)) continue;
            buffer.append(sep);
            sep = ", ";
            buffer.append(flags);
        }
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public Flags setImmutable() {
        this.immutable = true;
        return this;
    }

    @Override
    public abstract Flags clear();

    @Override
    public Flags clear(Flags flags) {
        this.checkImmutable();
        return this.andNot(flags);
    }

    @Override
    public Flags set(Flags flags) {
        this.checkImmutable();
        return this.or(flags);
    }

    @Override
    public abstract boolean test(Flags var1);

    protected FlagSet getFlagSetForModification() {
        if (this.immutable) {
            return (FlagSet)this.clone();
        }
        return this;
    }

    protected void checkImmutable() {
        if (this.immutable) {
            throw new UnsupportedOperationException("FlagSet is immutable");
        }
    }

    protected void checkFlags(Flags flags) {
        if (flags == null) {
            throw new NullPointerException("Flags must not be null");
        }
        Class<?> flagsClass = flags.getClass();
        if (!this.enumClass.equals(flagsClass) && !this.getClass().equals(flagsClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Flags must be of \"{0}\" or \"{1}\"", this.enumClass.getName(), this.getClass().getName()));
        }
    }
}

