/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.enumeration;

import com.meidusa.toolkit.common.util.enumeration.Enum;
import com.meidusa.toolkit.common.util.typeconvert.ConvertChain;
import com.meidusa.toolkit.common.util.typeconvert.ConvertFailedException;
import com.meidusa.toolkit.common.util.typeconvert.Converter;

public class EnumConverter
implements Converter {
    @Override
    public Object convert(Object value, ConvertChain chain) {
        Enum enumObj;
        Class targetType = chain.getTargetType();
        if (targetType.isInstance(value)) {
            return value;
        }
        if (value instanceof String && (enumObj = Enum.getEnumByName(targetType, ((String)value).trim())) != null) {
            return enumObj;
        }
        enumObj = null;
        try {
            Object enumValue = chain.getConvertManager().asTypeWithoutDefaultValue(Enum.getUnderlyingClass(targetType), value);
            enumObj = Enum.getEnumByValue(targetType, enumValue);
        }
        catch (ConvertFailedException e) {
            if (e.isDefaultValueSet() && (enumObj = Enum.getEnumByValue(targetType, e.getDefaultValue())) != null) {
                throw new ConvertFailedException(e).setDefaultValue(enumObj);
            }
            return chain.convert(value);
        }
        if (enumObj == null) {
            throw new ConvertFailedException();
        }
        return enumObj;
    }
}

