/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.enumeration;

import com.meidusa.toolkit.common.util.enumeration.BigIntegerEnum;
import com.meidusa.toolkit.common.util.enumeration.FlagSet;
import com.meidusa.toolkit.common.util.enumeration.Flags;
import java.math.BigInteger;
import java.text.MessageFormat;

public abstract class BigIntegerFlagSet
extends FlagSet {
    private static final long serialVersionUID = 148888351760285748L;
    private BigInteger value = BigInteger.ZERO;

    public BigIntegerFlagSet(Class enumClass) {
        super(enumClass);
        if (!BigIntegerEnum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Class \"{0}\" is not a subclass of \"{1}\"", enumClass.getName(), BigIntegerEnum.class.getName()));
        }
    }

    @Override
    public void setValue(Object value) {
        this.checkImmutable();
        if (value == null) {
            throw new NullPointerException("FlagSet value must not be null");
        }
        this.value = (BigInteger)value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Flags clear() {
        this.checkImmutable();
        this.value = BigInteger.ZERO;
        return this;
    }

    @Override
    public boolean test(Flags flags) {
        return !this.value.and(this.getFlagsValue(flags)).equals(BigInteger.ZERO);
    }

    @Override
    public boolean testAll(Flags flags) {
        BigInteger testValue = this.getFlagsValue(flags);
        return this.value.and(testValue).equals(testValue);
    }

    @Override
    public Flags and(Flags flags) {
        BigIntegerFlagSet flagSet = (BigIntegerFlagSet)this.getFlagSetForModification();
        flagSet.value = flagSet.value.and(this.getFlagsValue(flags));
        return flagSet;
    }

    @Override
    public Flags andNot(Flags flags) {
        BigIntegerFlagSet flagSet = (BigIntegerFlagSet)this.getFlagSetForModification();
        flagSet.value = flagSet.value.andNot(this.getFlagsValue(flags));
        return flagSet;
    }

    @Override
    public Flags or(Flags flags) {
        BigIntegerFlagSet flagSet = (BigIntegerFlagSet)this.getFlagSetForModification();
        flagSet.value = flagSet.value.or(this.getFlagsValue(flags));
        return flagSet;
    }

    @Override
    public Flags xor(Flags flags) {
        BigIntegerFlagSet flagSet = (BigIntegerFlagSet)this.getFlagSetForModification();
        flagSet.value = flagSet.value.xor(this.getFlagsValue(flags));
        return flagSet;
    }

    private BigInteger getFlagsValue(Flags flags) {
        this.checkFlags(flags);
        return flags instanceof BigIntegerEnum ? (BigInteger)((BigIntegerEnum)((Object)flags)).getValue() : ((BigIntegerFlagSet)flags).value;
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public String toHexString() {
        return this.value.toString(16);
    }

    @Override
    public String toOctalString() {
        return this.value.toString(8);
    }

    @Override
    public String toBinaryString() {
        return this.value.toString(2);
    }
}

