/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.enumeration;

import com.meidusa.toolkit.common.util.enumeration.Enum;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class BigIntegerEnum
extends Enum {
    static final long serialVersionUID = 3407019802348379119L;

    protected BigIntegerEnum(String name) {
        super(name);
    }

    protected BigIntegerEnum(String name, int value) {
        super(name, new BigInteger(String.valueOf(value)));
    }

    protected BigIntegerEnum(String name, long value) {
        super(name, new BigInteger(String.valueOf(value)));
    }

    protected BigIntegerEnum(String name, String value) {
        super(name, new BigInteger(value));
    }

    protected BigIntegerEnum(String name, BigInteger value) {
        super(name, value);
    }

    protected BigIntegerEnum(String name, BigDecimal value) {
        super(name, value.toBigInteger());
    }

    protected static Object createEnumType() {
        return new Enum.EnumType(){

            @Override
            protected Class getUnderlyingClass() {
                return BigInteger.class;
            }

            @Override
            protected Object getNextValue(Object value, boolean flagMode) {
                if (value == null) {
                    return flagMode ? BigInteger.ONE : BigInteger.ZERO;
                }
                if (flagMode) {
                    return ((BigInteger)value).shiftLeft(1);
                }
                return ((BigInteger)value).add(BigInteger.ONE);
            }

            @Override
            protected boolean isZero(Object value) {
                return ((BigInteger)value).equals(BigInteger.ZERO);
            }

            @Override
            protected boolean isPowerOfTwo(Object value) {
                BigInteger bintValue = (BigInteger)value;
                int bitIndex = bintValue.getLowestSetBit();
                if (bitIndex < 0) {
                    return false;
                }
                return bintValue.clearBit(bitIndex).equals(BigInteger.ZERO);
            }
        };
    }

    @Override
    public int intValue() {
        return ((BigInteger)this.getValue()).intValue();
    }

    @Override
    public long longValue() {
        return ((BigInteger)this.getValue()).longValue();
    }

    @Override
    public double doubleValue() {
        return ((BigInteger)this.getValue()).doubleValue();
    }

    @Override
    public float floatValue() {
        return ((BigInteger)this.getValue()).floatValue();
    }

    @Override
    public String toHexString() {
        return ((BigInteger)this.getValue()).toString(16);
    }

    @Override
    public String toOctalString() {
        return ((BigInteger)this.getValue()).toString(8);
    }

    @Override
    public String toBinaryString() {
        return ((BigInteger)this.getValue()).toString(2);
    }
}

