/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.configuration.digester;

import com.meidusa.toolkit.common.util.configuration.digester.ContextSensitiveRules;
import com.meidusa.toolkit.common.util.configuration.digester.RuleSetFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.xml.sax.Attributes;

public class SetRuleSetRule
extends Rule {
    private Class ruleSetFactoryClass;
    private RuleSetFactory ruleSetFactory;

    public SetRuleSetRule(Class ruleSetFactoryClass) {
        this.ruleSetFactoryClass = ruleSetFactoryClass;
    }

    public SetRuleSetRule(RuleSetFactory ruleSetFactory) {
        this.ruleSetFactory = ruleSetFactory;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String context;
        ContextSensitiveRules rules = (ContextSensitiveRules)this.digester.getRules();
        if (!rules.isInitialized(context = rules.getContext())) {
            rules.setInitializing(context);
            RuleSet ruleSet = this.getFactory().getRuleSet(attributes);
            this.digester.addRuleSet(ruleSet);
            rules.setInitialized(context);
            if (this.digester.getLogger().isDebugEnabled()) {
                this.digester.getLogger().debug((Object)("[SetRuleSetRule]{" + this.digester.getMatch() + "} New " + ruleSet));
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("SetRuleSetRule[");
        if (this.ruleSetFactoryClass != null) {
            buffer.append("ruleSetFactory=").append(this.ruleSetFactoryClass);
        } else if (this.ruleSetFactory != null) {
            buffer.append("ruleSetFactory=").append(this.ruleSetFactory);
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected RuleSetFactory getFactory() throws Exception {
        if (this.ruleSetFactory == null && this.ruleSetFactoryClass != null) {
            this.ruleSetFactory = (RuleSetFactory)this.ruleSetFactoryClass.newInstance();
        }
        this.ruleSetFactory.setDigester(this.digester);
        return this.ruleSetFactory;
    }
}

