/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.configuration.digester;

import com.meidusa.toolkit.common.util.configuration.digester.ContextFactory;
import com.meidusa.toolkit.common.util.configuration.digester.ContextSensitiveRules;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class SetContextRule
extends Rule {
    protected String attributeName;
    protected Class contextFactoryClass;
    protected ContextFactory contextFactory;

    public SetContextRule(String attributeName) {
        this.attributeName = attributeName;
    }

    public SetContextRule(Class contextFactoryClass) {
        this.contextFactoryClass = contextFactoryClass;
    }

    public SetContextRule(ContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String context = null;
        if (this.attributeName != null) {
            context = attributes.getValue(this.attributeName);
        }
        if (context == null && this.getFactory() != null) {
            context = this.getFactory().getContext(attributes);
        }
        if (context != null) {
            if (this.digester.getLogger().isDebugEnabled()) {
                this.digester.getLogger().debug((Object)("[SetContextRule]{" + this.digester.getMatch() + "} New " + context));
            }
            ContextSensitiveRules rules = (ContextSensitiveRules)this.digester.getRules();
            rules.pushContext(context);
        }
    }

    public void end(String namespace, String name) throws Exception {
        ContextSensitiveRules rules = (ContextSensitiveRules)this.digester.getRules();
        String context = rules.popContext();
        if (context != null && this.digester.getLogger().isDebugEnabled()) {
            this.digester.getLogger().debug((Object)("[SetContextRule]{" + this.digester.getMatch() + "} Pop " + context));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("SetContextRule[");
        if (this.attributeName != null) {
            buffer.append("attributeName=").append(this.attributeName);
        } else if (this.contextFactoryClass != null) {
            buffer.append("contextFactory=").append(this.contextFactoryClass);
        } else if (this.contextFactory != null) {
            buffer.append("contextFactory=").append(this.contextFactory);
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected ContextFactory getFactory() throws Exception {
        if (this.contextFactory == null && this.contextFactoryClass != null) {
            this.contextFactory = (ContextFactory)this.contextFactoryClass.newInstance();
        }
        this.contextFactory.setDigester(this.digester);
        return this.contextFactory;
    }
}

