/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.collection;

import com.meidusa.toolkit.common.util.collection.Collections;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class SynchronizedMap
implements Map,
Serializable {
    private static final long serialVersionUID = 1978198479659022715L;
    protected Map map;
    protected Object syncRoot;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;

    SynchronizedMap(Map map) {
        this(map, null);
    }

    SynchronizedMap(Map map, Object syncRoot) {
        if (map == null) {
            throw new NullPointerException();
        }
        this.map = map;
        this.syncRoot = syncRoot == null ? this : syncRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        Object object = this.syncRoot;
        synchronized (object) {
            this.map.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.keySet == null) {
                this.keySet = Collections.synchronizedSet(this.map.keySet(), this.syncRoot);
            }
            return this.keySet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.entrySet == null) {
                this.entrySet = Collections.synchronizedSet(this.map.entrySet(), this.syncRoot);
            }
            return this.entrySet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.values == null) {
                this.values = Collections.synchronizedCollection(this.map.values(), this.syncRoot);
            }
            return this.values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        Object object = this.syncRoot;
        synchronized (object) {
            return ((Object)this.map).equals(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.syncRoot;
        synchronized (object) {
            return ((Object)this.map).hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.map.toString();
        }
    }
}

