/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

class SynchronizedCollection
implements Collection,
Serializable {
    private static final long serialVersionUID = 3053995032091335093L;
    protected Collection collection;
    protected Object syncRoot;

    SynchronizedCollection(Collection collection) {
        this(collection, null);
    }

    SynchronizedCollection(Collection collection, Object syncRoot) {
        if (collection == null) {
            throw new NullPointerException();
        }
        this.collection = collection;
        this.syncRoot = syncRoot == null ? this : syncRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.toArray(a);
        }
    }

    @Override
    public Iterator iterator() {
        return this.collection.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection coll) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.containsAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection coll) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.addAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection coll) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.removeAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection coll) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.retainAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.collection.toString();
        }
    }
}

