/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.collection;

import com.meidusa.toolkit.common.util.collection.DefaultHashMap;
import com.meidusa.toolkit.common.util.collection.ListMap;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class ArrayHashMap
extends DefaultHashMap
implements ListMap {
    private static final long serialVersionUID = -108097684311309571L;
    protected transient Entry[] order;
    private transient List keyList;
    private transient List valueList;
    private transient List entryList;

    public ArrayHashMap() {
    }

    public ArrayHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ArrayHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ArrayHashMap(Map map) {
        super(map);
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.size; ++i) {
            Entry entry = this.order[i];
            if (!ArrayHashMap.eq(value, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.order, null);
    }

    @Override
    public Object get(int index) {
        this.checkRange(index);
        return this.order[index].getValue();
    }

    @Override
    public Object getKey(int index) {
        this.checkRange(index);
        return this.order[index].getKey();
    }

    @Override
    public Map.Entry remove(int index) {
        this.checkRange(index);
        return this.removeEntryForKey(this.order[index].getKey());
    }

    @Override
    public List keyList() {
        return this.keyList != null ? this.keyList : (this.keyList = new KeyList());
    }

    @Override
    public List valueList() {
        return this.valueList != null ? this.valueList : (this.valueList = new ValueList());
    }

    @Override
    public List entryList() {
        return this.entryList != null ? this.entryList : (this.entryList = new EntryList());
    }

    @Override
    protected void onInit() {
        this.order = new Entry[this.threshold];
    }

    @Override
    protected void addEntry(Object key, Object value) {
        int hash = ArrayHashMap.hash(key);
        int i = ArrayHashMap.indexFor(hash, this.table.length);
        Entry entry = new Entry(hash, key, value, this.table[i]);
        this.table[i] = entry;
        entry.index = this.size;
        this.order[this.size++] = entry;
    }

    @Override
    protected Iterator newKeyIterator() {
        return new KeyIterator(0);
    }

    @Override
    protected Iterator newValueIterator() {
        return new ValueIterator(0);
    }

    @Override
    protected Iterator newEntryIterator() {
        return new EntryIterator(0);
    }

    @Override
    protected void resize(int newCapacity) {
        super.resize(newCapacity);
        if (this.threshold > this.order.length) {
            Entry[] newOrder = new Entry[this.threshold];
            System.arraycopy(this.order, 0, newOrder, 0, this.order.length);
            this.order = newOrder;
        }
    }

    @Override
    protected void transfer(DefaultHashMap.Entry[] newTable) {
        int newCapacity = newTable.length;
        for (int i = 0; i < this.size; ++i) {
            Entry entry = this.order[i];
            int index = ArrayHashMap.indexFor(entry.hash, newCapacity);
            entry.next = newTable[index];
            newTable[index] = entry;
        }
    }

    private void checkRange(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private class ValueList
    extends ArrayHashList {
        private ValueList() {
        }

        @Override
        public boolean contains(Object o) {
            return ArrayHashMap.this.containsValue(o);
        }

        @Override
        public Iterator iterator() {
            return ArrayHashMap.this.newValueIterator();
        }

        @Override
        public boolean remove(Object o) {
            int index = this.indexOf(o);
            if (index != -1) {
                ArrayHashMap.this.remove(index);
                return true;
            }
            return false;
        }

        @Override
        public Object get(int index) {
            ArrayHashMap.this.checkRange(index);
            return ArrayHashMap.this.order[index].getValue();
        }

        @Override
        public int indexOf(Object o) {
            for (int i = 0; i < ArrayHashMap.this.size; ++i) {
                if (!DefaultHashMap.eq(o, ArrayHashMap.this.order[i].getValue())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public ListIterator listIterator(int index) {
            return new ValueIterator(index);
        }
    }

    private class KeyList
    extends ArrayHashList {
        private KeyList() {
        }

        @Override
        public boolean contains(Object o) {
            return ArrayHashMap.this.containsKey(o);
        }

        @Override
        public Iterator iterator() {
            return ArrayHashMap.this.newKeyIterator();
        }

        @Override
        public boolean remove(Object o) {
            Entry entry = (Entry)ArrayHashMap.this.getEntry(o);
            if (entry == null) {
                return false;
            }
            ArrayHashMap.this.removeEntry(entry);
            return true;
        }

        @Override
        public Object get(int index) {
            ArrayHashMap.this.checkRange(index);
            return ArrayHashMap.this.order[index].getKey();
        }

        @Override
        public int indexOf(Object o) {
            Entry entry = (Entry)ArrayHashMap.this.getEntry(o);
            if (entry != null) {
                return entry.index;
            }
            return -1;
        }

        @Override
        public ListIterator listIterator(int index) {
            return new KeyIterator(index);
        }
    }

    private class EntryList
    extends ArrayHashList {
        private EntryList() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Entry candidate = (Entry)ArrayHashMap.this.getEntry(entry.getKey());
            return DefaultHashMap.eq(candidate, entry);
        }

        @Override
        public Iterator iterator() {
            return ArrayHashMap.this.newEntryIterator();
        }

        @Override
        public boolean remove(Object o) {
            return ArrayHashMap.this.removeEntry(o) != null;
        }

        @Override
        public Object get(int index) {
            ArrayHashMap.this.checkRange(index);
            return ArrayHashMap.this.order[index];
        }

        @Override
        public int indexOf(Object o) {
            Entry entry;
            if (o != null && o instanceof Map.Entry && (entry = (Entry)ArrayHashMap.this.getEntry(((Map.Entry)o).getKey())) != null && entry.equals(o)) {
                return entry.index;
            }
            return -1;
        }

        @Override
        public ListIterator listIterator(int index) {
            return new EntryIterator(index);
        }
    }

    private abstract class ArrayHashList
    extends AbstractList {
        private ArrayHashList() {
        }

        @Override
        public int size() {
            return ArrayHashMap.this.size;
        }

        @Override
        public boolean isEmpty() {
            return ArrayHashMap.this.size == 0;
        }

        @Override
        public void clear() {
            ArrayHashMap.this.clear();
        }

        @Override
        public Object remove(int index) {
            ArrayHashMap.this.checkRange(index);
            return ArrayHashMap.this.removeEntryForKey(ArrayHashMap.this.order[index].getKey());
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }
    }

    private class EntryIterator
    extends ArrayHashIterator {
        protected EntryIterator(int index) {
            super(index);
        }

        @Override
        public Object next() {
            return this.nextEntry();
        }

        public Object previous() {
            return this.previousEntry();
        }
    }

    private class ValueIterator
    extends ArrayHashIterator {
        protected ValueIterator(int index) {
            super(index);
        }

        @Override
        public void set(Object o) {
            this.setValue(o);
        }

        @Override
        public Object next() {
            return this.nextEntry().getValue();
        }

        public Object previous() {
            return this.previousEntry().getValue();
        }
    }

    private class KeyIterator
    extends ArrayHashIterator {
        protected KeyIterator(int index) {
            super(index);
        }

        @Override
        public Object next() {
            return this.nextEntry().getKey();
        }

        public Object previous() {
            return this.previousEntry().getKey();
        }
    }

    private abstract class ArrayHashIterator
    implements ListIterator {
        private Entry lastReturned;
        private int cursor;
        private int expectedModCount;

        protected ArrayHashIterator(int index) {
            if (index < 0 || index > ArrayHashMap.this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            this.cursor = index;
            this.expectedModCount = ArrayHashMap.this.modCount;
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ArrayHashMap.this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            ArrayHashMap.this.removeEntryForKey(this.lastReturned.getKey());
            if (this.lastReturned.index < this.cursor) {
                --this.cursor;
            }
            this.lastReturned = null;
            this.expectedModCount = ArrayHashMap.this.modCount;
        }

        protected Entry nextEntry() {
            this.checkForComodification();
            if (this.cursor >= ArrayHashMap.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = ArrayHashMap.this.order[this.cursor++];
            return this.lastReturned;
        }

        protected Entry previousEntry() {
            this.checkForComodification();
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = ArrayHashMap.this.order[--this.cursor];
            return this.lastReturned;
        }

        protected void setValue(Object o) {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.setValue(o);
        }

        private void checkForComodification() {
            if (ArrayHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected class Entry
    extends DefaultHashMap.Entry {
        protected int index;

        protected Entry(int h, Object k, Object v, DefaultHashMap.Entry n) {
            super(h, k, v, n);
        }

        @Override
        protected void onRemove() {
            int numMoved = ArrayHashMap.this.size - this.index;
            if (numMoved > 0) {
                System.arraycopy(ArrayHashMap.this.order, this.index + 1, ArrayHashMap.this.order, this.index, numMoved);
            }
            ArrayHashMap.this.order[ArrayHashMap.this.size] = null;
            for (int i = this.index; i < ArrayHashMap.this.size; ++i) {
                --ArrayHashMap.this.order[i].index;
            }
        }
    }
}

