/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeTool {
    private static final String FORMAT_TYPE_TIMESTAMP = "yyyy-MM-dd HH:mm:ss";
    private static final String FORMAT_TYPE_DATE = "yyyy-MM-dd";
    private static final String FORMAT_TYPE_TIME = "HH:mm:ss";

    public static void main(String[] args) {
        System.out.println(TimeTool.before(new int[]{2002, 2}, new int[]{2003, 2}));
    }

    public static String getYearMonthStr(String year, String month) {
        int intMonth = Integer.parseInt(month) + 1;
        return year + "-" + (intMonth < 10 ? "0" + intMonth : "" + intMonth);
    }

    public static Calendar getCalenarDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar;
    }

    public static boolean before(int[] yearMonth01, int[] yearMonth02) {
        return yearMonth01[0] < yearMonth02[0] || yearMonth01[0] == yearMonth02[0] && yearMonth01[1] < yearMonth02[1];
    }

    public static boolean after(int[] yearMonth01, int[] yearMonth02) {
        return yearMonth01[0] > yearMonth02[0] || yearMonth01[0] == yearMonth02[0] && yearMonth01[1] > yearMonth02[1];
    }

    public static boolean equals(int[] yearMonth01, int[] yearMonth02) {
        return yearMonth01[0] == yearMonth02[0] && yearMonth01[1] == yearMonth02[1];
    }

    public static boolean equalsYearMonthDay(Calendar calendar01, Calendar calendar02) {
        return calendar01.get(1) == calendar02.get(1) && calendar01.get(2) == calendar02.get(2) && calendar01.get(5) == calendar02.get(5);
    }

    public static String getWeekShow(int week) {
        if (week < 1 || week > 7) {
            return null;
        }
        String[] WEEK = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        return WEEK[week - 1];
    }

    public static void addMonth(int[] yearMonth, int amount) {
        int year = yearMonth[0];
        int month = yearMonth[1];
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException(TimeTool.class.getName() + " addMonth month is invaid:month = " + month);
        }
        year += amount / 12;
        if ((month += amount % 12) < 0) {
            month += 12;
        } else if (month > 11) {
            month -= 12;
            ++year;
        }
        yearMonth[0] = --year;
        yearMonth[1] = month;
    }

    public static int diffOfDay(Calendar calendar1, Calendar calendar2) {
        long time = TimeTool.diffOfMillis(calendar1, calendar2);
        return (int)(time / 86400000L);
    }

    public static int diffOfField(Calendar calendar1, Calendar calendar2, int field) {
        return Math.abs(calendar1.get(field) - calendar2.get(field));
    }

    public static long diffOfMillis(Calendar calendar1, Calendar calendar2) {
        return Math.abs(calendar1.getTimeInMillis() - calendar2.getTimeInMillis());
    }

    public static String longToStrDateTime(long time) {
        return TimeTool.dateToStrDateTime(new Date(time));
    }

    public static Calendar longToCalendar(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return calendar;
    }

    public static long strDateTimeToLong(String str) {
        return TimeTool.strDateTimeToDate(str).getTime();
    }

    public static long calendarToLong(Calendar calendar) {
        if (calendar == null) {
            return -1L;
        }
        return calendar.getTimeInMillis();
    }

    public static String getDateTime() {
        return TimeTool.dateToStrDateTime(new Date());
    }

    public static String getDate() {
        return TimeTool.dateToStrDate(new Date());
    }

    public static String getTime() {
        return TimeTool.dateToStrTime(new Date());
    }

    public static Date strDateTimeToDate(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (str.length() == 10) {
            str = str + " 00:00:00";
        }
        return new SimpleDateFormat(FORMAT_TYPE_TIMESTAMP).parse(str, new ParsePosition(0));
    }

    public static Calendar strDateTimeToCalendar(String str) {
        Calendar calendar = Calendar.getInstance();
        Date date = TimeTool.strDateTimeToDate(str);
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar strToCalendar(String str) {
        return TimeTool.strDateTimeToCalendar(str);
    }

    public static Date strDateToDate(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (str.length() == 7) {
            str = str + "-01 00:00:00";
        }
        return new SimpleDateFormat(FORMAT_TYPE_DATE).parse(str, new ParsePosition(0));
    }

    public static Calendar strDateToCalendar(String str) {
        Calendar calendar = Calendar.getInstance();
        Date date = TimeTool.strDateToDate(str);
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        return calendar;
    }

    public static String dateToStrDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(FORMAT_TYPE_TIMESTAMP).format(date);
    }

    public static String calendarToStrDateTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return TimeTool.dateToStrDateTime(calendar.getTime());
    }

    public static String dateToStrDate(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(FORMAT_TYPE_DATE).format(date);
    }

    public static String calendarToStrDate(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return TimeTool.dateToStrDate(calendar.getTime());
    }

    public static String dateToStrTime(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(FORMAT_TYPE_TIME).format(date);
    }

    public static String calendarToStrTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return TimeTool.dateToStrTime(calendar.getTime());
    }
}

