/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util;

import com.meidusa.toolkit.common.util.collection.ArrayHashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import org.apache.log4j.Logger;

public class ContextClassLoader {
    private static Logger logger = Logger.getLogger(ContextClassLoader.class);
    private static Method GET_CONTEXT_CLASS_LOADER_METHOD = null;

    public static URL[] getResources(String resourceName) {
        Object classLoader = null;
        ArrayHashSet urlSet = new ArrayHashSet();
        boolean found = false;
        found = ContextClassLoader.getResources(urlSet, resourceName, ContextClassLoader.getClassLoader(), false);
        if (!found) {
            ContextClassLoader.getResources(urlSet, resourceName, ContextClassLoader.class.getClassLoader(), false);
        }
        if (!found) {
            ContextClassLoader.getResources(urlSet, resourceName, null, true);
        }
        if (found) {
            return urlSet.toArray(new URL[urlSet.size()]);
        }
        return new URL[0];
    }

    private static boolean getResources(Set urlSet, String resourceName, ClassLoader classLoader, boolean sysClassLoader) {
        Enumeration<URL> i = null;
        try {
            if (classLoader != null) {
                i = classLoader.getResources(resourceName);
            } else if (sysClassLoader) {
                i = ClassLoader.getSystemResources(resourceName);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (i != null && i.hasMoreElements()) {
            while (i.hasMoreElements()) {
                urlSet.add(i.nextElement());
            }
            return true;
        }
        return false;
    }

    public static URL getResource(String resourceName) {
        ClassLoader classLoader = null;
        URL url = null;
        classLoader = ContextClassLoader.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resourceName)) != null) {
            return url;
        }
        classLoader = ContextClassLoader.class.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resourceName)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resourceName);
    }

    public static InputStream getResourceAsStream(String resourceName) {
        URL url = ContextClassLoader.getResource(resourceName);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return ContextClassLoader.loadClass(className, true, null);
    }

    public static Class loadClass(String className, boolean initialize, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            classLoader = ContextClassLoader.getClassLoader();
        }
        return Class.forName(className, initialize, classLoader);
    }

    public static ClassLoader getClassLoader() {
        if (GET_CONTEXT_CLASS_LOADER_METHOD != null) {
            try {
                return (ClassLoader)GET_CONTEXT_CLASS_LOADER_METHOD.invoke((Object)Thread.currentThread(), null);
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    public static File findLibrary(File parent, String libraryName) {
        String s = System.mapLibraryName(libraryName);
        return new File(parent, s);
    }

    public static void loadLibrary(String libraryName) {
        String projectLibraryPath = System.getProperty("project.library.path");
        File libraryFile = null;
        boolean loaded = false;
        if (projectLibraryPath != null) {
            libraryFile = ContextClassLoader.findLibrary(new File(projectLibraryPath), libraryName);
            if (libraryFile.exists()) {
                ContextClassLoader.loadLibrary(libraryFile.getParentFile(), libraryName);
                loaded = true;
            } else {
                loaded = ContextClassLoader.loadFromHomePath(libraryName);
            }
        } else {
            loaded = ContextClassLoader.loadFromHomePath(libraryName);
        }
        if (!loaded) {
            libraryFile = ContextClassLoader.findLibrary(new File("."), libraryName);
            if (libraryFile.exists()) {
                ContextClassLoader.loadLibrary(libraryFile.getParentFile(), libraryName);
            } else {
                System.loadLibrary(libraryName);
                logger.info((Object)("libraryName=" + System.mapLibraryName(libraryName) + " load from system path"));
            }
        }
    }

    private static boolean loadFromHomePath(String libraryName) {
        File libraryFile = null;
        String projectHome = System.getProperty("project.home");
        if (projectHome != null) {
            libraryFile = ContextClassLoader.findLibrary(new File(projectHome, "native"), libraryName);
            if (libraryFile.exists()) {
                ContextClassLoader.loadLibrary(libraryFile.getParentFile(), libraryName);
                logger.info((Object)("loaded from " + libraryFile.getAbsolutePath()));
                return true;
            }
            libraryFile = ContextClassLoader.findLibrary(new File(projectHome), libraryName);
            if (libraryFile.exists()) {
                ContextClassLoader.loadLibrary(libraryFile.getParentFile(), libraryName);
                logger.info((Object)("loaded from " + libraryFile.getAbsolutePath()));
                return true;
            }
        }
        return false;
    }

    public static void loadLibrary(File parent, String libraryName) {
        try {
            Method llm = ClassLoader.class.getDeclaredMethod("loadLibrary0", Class.class, File.class);
            llm.setAccessible(true);
            File lib = ContextClassLoader.findLibrary(parent, libraryName);
            if (!lib.exists()) {
                logger.error((Object)("loadLibrary error,File not found:" + lib.getAbsolutePath()));
                throw new RuntimeException("File not found:" + lib.getAbsolutePath());
            }
            llm.invoke(null, ContextClassLoader.class, lib);
            logger.info((Object)("loaded from " + lib.getAbsolutePath()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            GET_CONTEXT_CLASS_LOADER_METHOD = Thread.class.getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

