/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.tableformat;

import com.meidusa.toolkit.common.tableformat.AbstractTableFormatter;
import com.meidusa.toolkit.common.tableformat.TableFormatter;
import java.util.ArrayList;

public final class SimpleTableFormatter
extends AbstractTableFormatter
implements TableFormatter {
    private boolean border = false;

    public SimpleTableFormatter() {
    }

    public SimpleTableFormatter(boolean border) {
        this();
        this.border = border;
    }

    @Override
    public int getTableWidth() {
        int width = super.getTableWidth();
        if (this.border) {
            width += 2;
            if (this.getColumnCount() > 1) {
                width += this.getColumnCount() - 1;
            }
        }
        return width;
    }

    @Override
    public int getTableHeight() {
        int height = super.getTableHeight();
        if (this.border) {
            height += 2;
            if (this.getRowCount() > 1) {
                height += this.getRowCount() - 1;
            }
        }
        return height;
    }

    @Override
    public String[] getFormattedRow(int rowIndex) {
        int i;
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            throw new IllegalArgumentException("rowIndex");
        }
        int cellHeight = this.getRowHeight(rowIndex);
        ArrayList<StringBuffer> rowLines = new ArrayList<StringBuffer>(cellHeight);
        for (i = 0; i < cellHeight; ++i) {
            StringBuffer buffer = new StringBuffer();
            if (this.border) {
                buffer.append('|');
            }
            rowLines.add(buffer);
        }
        if (rowLines.size() != cellHeight) {
            throw new IllegalStateException("rowLines.size()");
        }
        int columnCount = this.getColumnCount();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            String[] cell = this.getFormattedCell(rowIndex, columnIndex);
            if (cell.length != cellHeight) {
                throw new IllegalStateException("cell.size()");
            }
            for (int i2 = 0; i2 < cellHeight; ++i2) {
                StringBuffer buffer = (StringBuffer)rowLines.get(i2);
                if (columnIndex > 0 && this.border) {
                    buffer.append('|');
                }
                buffer.append(cell[i2]);
            }
        }
        if (this.border) {
            for (i = 0; i < cellHeight; ++i) {
                StringBuffer buffer = (StringBuffer)rowLines.get(i);
                buffer.append('|');
            }
        }
        if (rowLines.size() != cellHeight) {
            throw new IllegalStateException("rowLines.size()");
        }
        ArrayList<String> result = new ArrayList<String>(cellHeight);
        for (int i3 = 0; i3 < cellHeight; ++i3) {
            StringBuffer buffer = (StringBuffer)rowLines.get(i3);
            result.add(buffer.toString());
        }
        if (result.size() != cellHeight) {
            throw new IllegalStateException("result.size()");
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getFormattedTable() {
        ArrayList<String> result = new ArrayList<String>();
        String borderText = null;
        if (this.border) {
            borderText = this.getFormattedBorder();
            result.add(borderText);
        }
        int rowCount = this.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            if (rowIndex > 0 && this.border) {
                result.add(borderText);
            }
            String[] row = this.getFormattedRow(rowIndex);
            int size = row.length;
            for (int i = 0; i < size; ++i) {
                result.add(row[i]);
            }
        }
        if (this.border) {
            result.add(borderText);
        }
        return result.toArray(new String[result.size()]);
    }

    private String getFormattedBorder() {
        StringBuffer result = new StringBuffer();
        result.append('+');
        int columnCount = this.getColumnCount();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            if (columnIndex > 0) {
                result.append('+');
            }
            for (int i = 0; i < this.getColumnWidth(columnIndex); ++i) {
                result.append('-');
            }
        }
        result.append('+');
        return result.toString();
    }
}

