/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.tableformat;

import com.meidusa.toolkit.common.tableformat.TableFormatter;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTableFormatter
implements TableFormatter {
    private int columnCount = 0;
    private List maxColWidths = new ArrayList();
    private List maxRowHeights = new ArrayList();
    private List tableData = new ArrayList();

    protected AbstractTableFormatter() {
    }

    @Override
    public final TableFormatter addLine() {
        return this.addLine(null);
    }

    @Override
    public final TableFormatter addLine(String text) {
        if (this.tableData.size() <= 0) {
            throw new IllegalStateException("tableData.size()");
        }
        List row = (List)this.tableData.get(this.tableData.size() - 1);
        if (row.size() <= 0) {
            throw new IllegalStateException("Cannot addLine() to empty row.  Use nextCell() first.");
        }
        CellData cell = (CellData)row.get(row.size() - 1);
        cell.addLine(text);
        if (this.maxColWidths.size() != this.columnCount) {
            throw new IllegalStateException("maxColWidths.size()");
        }
        int currentCol = row.size() - 1;
        int maxColWidth = (Integer)this.maxColWidths.get(currentCol);
        if (text != null && text.length() > maxColWidth) {
            this.maxColWidths.set(currentCol, new Integer(text.length()));
        }
        if (this.maxRowHeights.size() != this.tableData.size()) {
            throw new IllegalStateException("maxRowHeights.size()");
        }
        int currentRow = this.tableData.size() - 1;
        int maxRowHeight = (Integer)this.maxRowHeights.get(currentRow);
        if (cell.getLineCount() > maxRowHeight) {
            this.maxRowHeights.set(currentRow, new Integer(cell.getLineCount()));
        }
        return this;
    }

    @Override
    public final TableFormatter nextCell() {
        return this.nextCell(0, 4);
    }

    @Override
    public final TableFormatter nextCell(int align, int valign) {
        if (align != 0 && align != 1 && align != 2 && align != 3) {
            throw new IllegalArgumentException("align");
        }
        if (valign != 4 && valign != 5 && valign != 6 && valign != 7) {
            throw new IllegalArgumentException("valign");
        }
        if (this.tableData.size() <= 0) {
            throw new IllegalStateException("tableData.size()");
        }
        List row = (List)this.tableData.get(this.tableData.size() - 1);
        CellData cell = new CellData(align, valign);
        row.add(cell);
        if (row.size() > this.columnCount) {
            if (row.size() - 1 != this.columnCount) {
                throw new IllegalStateException("columnCount");
            }
            this.columnCount = row.size();
            this.maxColWidths.add(new Integer(0));
        }
        return this;
    }

    @Override
    public final TableFormatter nextRow() {
        this.tableData.add(new ArrayList(this.columnCount));
        this.maxRowHeights.add(new Integer(0));
        return this;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public final int getRowCount() {
        if (this.tableData.size() <= 0) {
            throw new IllegalStateException("tableData.size()");
        }
        return this.tableData.size();
    }

    @Override
    public final int getColumnWidth(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnCount) {
            throw new IllegalArgumentException("columnIndex");
        }
        return (Integer)this.maxColWidths.get(columnIndex);
    }

    @Override
    public final int getRowHeight(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.tableData.size()) {
            throw new IllegalArgumentException("rowIndex");
        }
        return (Integer)this.maxRowHeights.get(rowIndex);
    }

    @Override
    public final String[] getFormattedCell(int rowIndex, int columnIndex) {
        int i;
        int topPad;
        int bottomPad;
        int valign;
        int align;
        List lines;
        if (rowIndex < 0 || rowIndex >= this.tableData.size()) {
            throw new IllegalArgumentException("rowIndex");
        }
        if (columnIndex < 0 || columnIndex >= this.columnCount) {
            throw new IllegalArgumentException("columnIndex");
        }
        int cellWidth = this.getColumnWidth(columnIndex);
        int cellHeight = this.getRowHeight(rowIndex);
        List row = (List)this.tableData.get(rowIndex);
        if (row.size() > columnIndex) {
            CellData cell = (CellData)row.get(columnIndex);
            lines = cell.getLines();
            align = cell.getAlign();
            valign = cell.getVAlign();
        } else {
            lines = new ArrayList();
            align = 0;
            valign = 4;
        }
        int vpadding = cellHeight - lines.size();
        switch (valign) {
            case 6: {
                int carry = vpadding % 2;
                topPad = bottomPad = (vpadding -= carry) / 2;
                bottomPad += carry;
                break;
            }
            case 7: {
                topPad = vpadding;
                bottomPad = 0;
                break;
            }
            default: {
                topPad = 0;
                bottomPad = vpadding;
            }
        }
        ArrayList<String> result = new ArrayList<String>(cellHeight);
        for (i = 0; i < topPad; ++i) {
            result.add(this.getFormattedLine("", cellWidth, align));
        }
        for (i = 0; i < lines.size(); ++i) {
            result.add(this.getFormattedLine((String)lines.get(i), cellWidth, align));
        }
        for (i = 0; i < bottomPad; ++i) {
            result.add(this.getFormattedLine("", cellWidth, align));
        }
        if (result.size() != cellHeight) {
            throw new IllegalStateException("result.size()");
        }
        return result.toArray(new String[result.size()]);
    }

    private final String getFormattedLine(String text, int lineLength, int align) {
        int i;
        int leftPad;
        int rightPad;
        if (text == null) {
            text = "";
        }
        int padding = lineLength - text.length();
        switch (align) {
            case 2: {
                int carry = padding % 2;
                leftPad = rightPad = (padding -= carry) / 2;
                rightPad += carry;
                break;
            }
            case 3: {
                leftPad = padding;
                rightPad = 0;
                break;
            }
            default: {
                leftPad = 0;
                rightPad = padding;
            }
        }
        StringBuffer result = new StringBuffer();
        for (i = 0; i < leftPad; ++i) {
            result.append(' ');
        }
        result.append(text);
        for (i = 0; i < rightPad; ++i) {
            result.append(' ');
        }
        return result.toString();
    }

    @Override
    public int getTableWidth() {
        if (this.maxColWidths.size() != this.getColumnCount()) {
            throw new IllegalStateException("maxColWidths.size()");
        }
        int width = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            width += ((Integer)this.maxColWidths.get(i)).intValue();
        }
        return width;
    }

    @Override
    public int getTableHeight() {
        if (this.maxRowHeights.size() != this.getRowCount()) {
            throw new IllegalStateException("maxRowHeights.size()");
        }
        int height = 0;
        int size = this.maxRowHeights.size();
        for (int i = 0; i < size; ++i) {
            height += ((Integer)this.maxRowHeights.get(i)).intValue();
        }
        return height;
    }

    protected class CellData {
        private List lines;
        private int align;
        private int valign;

        private CellData() {
        }

        public CellData(int align, int valign) {
            this();
            this.lines = new ArrayList();
            this.align = align;
            this.valign = valign;
        }

        public void addLine(String text) {
            this.lines.add(text);
        }

        public int getLineCount() {
            return this.lines.size();
        }

        public List getLines() {
            return new ArrayList(this.lines);
        }

        public int getAlign() {
            return this.align;
        }

        public int getVAlign() {
            return this.valign;
        }
    }
}

