/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.runtime;

import com.meidusa.toolkit.common.runtime.Application;
import com.meidusa.toolkit.common.runtime.Command;
import com.meidusa.toolkit.common.runtime.ShutdownRunner;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class ShutdownClient
extends ShutdownRunner {
    public ShutdownClient(String appplicationName) {
        super(appplicationName);
    }

    @Override
    public void run() {
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
            System.exit(-1);
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.socketInfoFile));
            String port = reader.readLine();
            Socket socket = new Socket(address, Integer.parseInt(port));
            ObjectOutputStream os = new ObjectOutputStream(socket.getOutputStream());
            os.writeObject(Command.SHUTDOWN);
            ObjectInputStream is = new ObjectInputStream(socket.getInputStream());
            if (is.readObject() == Command.OK) {
                System.out.println("remote application= " + this.appplicationName + ":" + port + " shutdown completed");
            }
            this.socketInfoFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String applicationName = System.getProperty("application.name", Application.class.getSimpleName());
        ShutdownClient client = new ShutdownClient(applicationName);
        client.init();
        client.run();
    }
}

