/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.runtime;

import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.BeanContextBean;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.common.runtime.ApplicationConfig;
import com.meidusa.toolkit.common.runtime.ShutdownServer;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.Log4jConfigurer;
import org.springframework.util.SystemPropertyUtils;

public abstract class Application<T extends ApplicationConfig>
implements Runnable {
    private static Logger logger = Logger.getLogger(Application.class);
    protected AutowireCapableBeanFactory factory;
    private AbstractApplicationContext context;
    private BeanContext beanContext;
    private String[] args;

    protected abstract String[] getConfigLocations();

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public abstract T getApplicationConfig();

    public <V> V createBean(Class<V> clazz) {
        return (V)this.getBeanFactory().autowire(clazz, 1, false);
    }

    private AutowireCapableBeanFactory getBeanFactory() {
        if (this.factory == null) {
            this.factory = this.context.getAutowireCapableBeanFactory();
        }
        return this.factory;
    }

    public void autowireBean(Object object) {
        this.getBeanFactory().autowireBeanProperties(object, 1, false);
    }

    protected static void setUpSystemProperties() {
        File projectHome = new File(SystemPropertyUtils.resolvePlaceholders((String)System.getProperty("project.home", ".")));
        System.setProperty("project.home", projectHome.getAbsolutePath());
        File projectOut = new File(SystemPropertyUtils.resolvePlaceholders((String)System.getProperty("project.output", ".")));
        System.setProperty("project.output", projectOut.getAbsolutePath());
    }

    public void setUp() throws Exception {
        logger.warn((Object)(this.getClass() + "  startup.."));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.warn((Object)(Application.this.getClass() + "  shutdown.."));
            }
        });
        Application.setUpSystemProperties();
        this.beanContext = new BeanContext(){

            public Object getBean(String beanName) {
                if (Application.this.getBeanFactory() != null) {
                    return Application.this.getBeanFactory().getBean(beanName);
                }
                return null;
            }

            public Object createBean(Class clazz) throws Exception {
                if (Application.this.getBeanFactory() instanceof AutowireCapableBeanFactory) {
                    AutowireCapableBeanFactory factory = Application.this.getBeanFactory();
                    return factory.autowire(clazz, 1, true);
                }
                return null;
            }
        };
        BeanContextBean.getInstance().setBeanContext(this.beanContext);
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean()){

            public void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
                block8: {
                    if (value instanceof String) {
                        PropertyDescriptor descriptor = null;
                        try {
                            descriptor = this.getPropertyUtils().getPropertyDescriptor(bean, name);
                            if (descriptor == null) {
                                return;
                            }
                            if (descriptor.getPropertyType().isEnum()) {
                                Class<?> clazz = descriptor.getPropertyType();
                                value = Enum.valueOf(clazz, (String)value);
                                break block8;
                            }
                            Object temp = null;
                            try {
                                temp = ConfigUtil.filter((String)((String)value), (BeanContext)Application.this.beanContext);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (temp == null) {
                                temp = ConfigUtil.filter((String)((String)value));
                            }
                            value = temp;
                        }
                        catch (NoSuchMethodException e) {
                            return;
                        }
                    }
                }
                super.setProperty(bean, name, value);
            }
        });
        if (this.getConfigLocations() != null && this.factory == null) {
            this.context = new ClassPathXmlApplicationContext(this.getConfigLocations(), false);
            this.context.refresh();
            if (this instanceof BeanFactoryAware) {
                BeanFactoryAware aware = (BeanFactoryAware)this;
                aware.setBeanFactory((BeanFactory)this.factory);
            }
            this.autowireBean(this);
        }
        if (this.getApplicationConfig() != null) {
            this.getApplicationConfig().init();
        }
    }

    public abstract void doRun();

    @Override
    public void run() {
        try {
            String applicationName = System.getProperty("application.name", this.getClass().getSimpleName());
            ShutdownServer server = new ShutdownServer(applicationName);
            server.init();
            server.start();
            server.waitForRun();
            this.setUp();
        }
        catch (Exception e) {
            logger.error((Object)"init application error", (Throwable)e);
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            this.doRun();
        }
        catch (Exception e) {
            logger.error((Object)"run application error", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void runInContainer() {
        new Thread(){
            {
                this.setName(Application.this.getClass() + "_application");
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    Application.this.setUp();
                    Application.this.doRun();
                }
                catch (Exception e) {
                    logger.error((Object)"run application error", (Throwable)e);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public static void main(String[] args) {
        String mainClass = System.getProperty("project.mainClass");
        Application.setUpSystemProperties();
        String log4jConf = System.getProperty("log4j.conf", "${project.home}/conf/log4j.xml");
        log4jConf = ConfigUtil.filter((String)log4jConf, (Properties)System.getProperties());
        try {
            Log4jConfigurer.initLogging((String)log4jConf, (long)60000L);
        }
        catch (FileNotFoundException e1) {
            String needLog4j = System.getProperty("log4j", "false");
            if (Boolean.valueOf(needLog4j).booleanValue()) {
                System.out.println("log4jConf not found:" + log4jConf + ", system exit");
                System.exit(-1);
            }
            System.out.println("log4jConf not found:" + log4jConf);
        }
        if (StringUtils.isEmpty((String)mainClass)) {
            logger.error((Object)"application main class is null,pls set System property such as \"-Dproject.mainClass=mainClass\"");
            System.out.println("application main class is null,pls set System property such as \"-Dproject.mainClass=mainClass\"");
            System.exit(-1);
        } else {
            try {
                logger.info((Object)("starting run application with main class :" + mainClass));
                Application app = (Application)Class.forName(mainClass).newInstance();
                app.setArgs(args);
                app.run();
            }
            catch (Exception e) {
                logger.error((Object)("run application error with " + mainClass), (Throwable)e);
                e.printStackTrace();
            }
        }
    }
}

