/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.heartbeat;

import com.meidusa.toolkit.common.heartbeat.Status;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class HeartbeatDelayed
implements Delayed {
    private long time;
    private final long sequenceNumber;
    private long nano_origin;
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private long nextFireTime;

    public boolean isCycle() {
        return false;
    }

    public HeartbeatDelayed(long nsTime, TimeUnit timeUnit) {
        this.nextFireTime = this.nano_origin = System.nanoTime();
        this.time = TimeUnit.NANOSECONDS.convert(nsTime, timeUnit);
        this.sequenceNumber = sequencer.getAndIncrement();
        this.nextFireTime = this.time + this.nano_origin;
    }

    public abstract String getName();

    public void setDelayedTime(long time, TimeUnit timeUnit) {
        this.nano_origin = System.nanoTime();
        this.time = TimeUnit.NANOSECONDS.convert(time, timeUnit);
        this.nextFireTime = time + this.nano_origin;
    }

    public void cancel() {
    }

    public void reset() {
        this.nano_origin = System.nanoTime();
        this.nextFireTime = this.time + this.nano_origin;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long d = unit.convert(this.time - this.now(), TimeUnit.NANOSECONDS);
        return d;
    }

    public abstract Status doCheck();

    @Override
    public int compareTo(Delayed other) {
        if (other == this) {
            return 0;
        }
        HeartbeatDelayed x = (HeartbeatDelayed)other;
        long diff = this.nextFireTime - x.nextFireTime;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        if (this.sequenceNumber < x.sequenceNumber) {
            return -1;
        }
        return 1;
    }

    final long now() {
        return System.nanoTime() - this.nano_origin;
    }
}

