/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint;

import com.lewisd.maven.lint.Rule;
import com.lewisd.maven.lint.Violation;
import com.lewisd.maven.lint.ViolationSuppressor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.maven.model.InputLocation;

public class ViolationSuppressorImpl
implements ViolationSuppressor {
    @Override
    public boolean isSuppressed(Violation violation) {
        return this.findSuppressionComment(violation) != null;
    }

    public String findSuppressionComment(Violation violation) {
        Rule rule = violation.getRule();
        InputLocation inputLocation = violation.getInputLocation();
        return this.findSuppressionComment(rule, inputLocation);
    }

    private String findSuppressionComment(Rule rule, InputLocation inputLocation) {
        File file = new File(inputLocation.getSource().getLocation());
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            for (int lineNo = 1; (line = reader.readLine()) != null && lineNo < inputLocation.getLineNumber(); ++lineNo) {
            }
            if (line != null) {
                if (inputLocation.getColumnNumber() < 1 && inputLocation.getColumnNumber() > line.length()) {
                    return this.findSuppressionComment(rule, line, reader);
                }
                String lineAfterViolation = inputLocation.getColumnNumber() > 0 ? line.substring(inputLocation.getColumnNumber() - 1) : line;
                return this.findSuppressionComment(rule, lineAfterViolation, reader);
            }
        }
        catch (IOException e) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Error while checking for suppression in " + file, e);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String findSuppressionComment(Rule rule, String originalLine, BufferedReader reader) throws IOException {
        String line = originalLine;
        int index = 0;
        String comment = "";
        boolean tagClosed = false;
        ParserState state = ParserState.UNKNOWN;
        while (true) {
            if (index >= line.length()) {
                index = 0;
                line = reader.readLine();
                comment = comment + "\n";
                if (line != null) continue;
                return null;
            }
            char c = line.charAt(index);
            if (state == ParserState.STARTING_TAG) {
                if (c == '!') {
                    comment = comment + c;
                    state = ParserState.STARTING_COMMENT;
                } else {
                    if (c != '/') return null;
                    if (tagClosed) {
                        return null;
                    }
                    state = ParserState.IN_END_TAG;
                    tagClosed = true;
                }
            } else if (state == ParserState.STARTING_COMMENT) {
                comment = comment + c;
                if (c != '-') {
                    state = ParserState.IN_COMMENT;
                }
            } else if (state == ParserState.IN_COMMENT) {
                comment = comment + c;
                if (c == '>') {
                    state = ParserState.UNKNOWN;
                    if (this.containsSuppression(rule, comment)) {
                        return comment;
                    }
                }
            } else if (state == ParserState.IN_END_TAG) {
                if (c == '>') {
                    state = ParserState.UNKNOWN;
                }
            } else if (c == '<') {
                state = ParserState.STARTING_TAG;
                comment = "<";
            }
            ++index;
        }
    }

    private boolean containsSuppression(Rule rule, String comment) {
        return comment.toUpperCase().contains(("NOLINT:" + rule.getIdentifier()).toUpperCase());
    }

    private static enum ParserState {
        UNKNOWN,
        STARTING_TAG,
        STARTING_COMMENT,
        IN_COMMENT,
        IN_END_TAG;

    }
}

