/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.hickory.testing;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import net.java.dev.hickory.testing.MemFileManager;
import net.java.dev.hickory.testing.MemSourceFileObject;
import net.java.dev.hickory.testing.RuntimeTest;
import net.java.dev.hickory.testing.TestCode;

public class Compilation {
    private final JavaCompiler compiler;
    private final DiagnosticCollector<JavaFileObject> diagnostics;
    private MemFileManager jfm;
    private final List<JavaFileObject> jfos;
    private boolean done;
    private boolean success;
    private List<Processor> processors;

    public Compilation() {
        this(null);
    }

    public Compilation(Compilation previous) {
        if (previous != null && !previous.done) {
            throw new IllegalStateException("Previous compilation has not yet been compiled.");
        }
        this.compiler = ToolProvider.getSystemJavaCompiler();
        if (previous == null) {
            StandardJavaFileManager sjfm = this.compiler.getStandardFileManager(null, null, null);
            this.jfm = new MemFileManager(sjfm);
        } else {
            this.jfm = previous.jfm;
        }
        this.diagnostics = new DiagnosticCollector();
        this.jfos = new ArrayList<JavaFileObject>();
    }

    public MemSourceFileObject addSource(String fqn) {
        if (this.done) {
            throw new IllegalStateException("cannot call after doCompilation()");
        }
        MemSourceFileObject result = new MemSourceFileObject(fqn);
        this.jfos.add(result);
        return result;
    }

    public RuntimeTest createRuntimeTest(TestCode code) {
        if (!this.done) {
            throw new IllegalStateException("cannot call before doCompilation()");
        }
        return new RuntimeTest(code, this.jfm);
    }

    public void doCompile(Writer out, String ... options) {
        if (this.done) {
            throw new IllegalStateException("cannot call after doCompilation()");
        }
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.addAll(Arrays.asList("-classpath", System.getProperty("java.class.path")));
        optionList.addAll(Arrays.asList(options));
        JavaCompiler.CompilationTask task = this.compiler.getTask(out, this.jfm, this.diagnostics, optionList, null, this.jfos);
        if (this.processors != null) {
            task.setProcessors(this.processors);
        }
        this.success = task.call();
        this.done = true;
    }

    public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
        if (!this.done) {
            throw new IllegalStateException("cannot call before doCompilation()");
        }
        return this.diagnostics.getDiagnostics();
    }

    public String getGeneratedResource(String filename) {
        if (!this.done) {
            throw new IllegalStateException("cannot call before doCompilation()");
        }
        try {
            JavaFileObject jfo = this.jfm.getJavaFileForOutput(StandardLocation.SOURCE_OUTPUT, filename, JavaFileObject.Kind.OTHER, null);
            if (jfo == null) {
                return null;
            }
            return ((Object)jfo.getCharContent(true)).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getGeneratedSource(String fqn) {
        if (!this.done) {
            throw new IllegalStateException("cannot call before doCompilation()");
        }
        try {
            String name = fqn.replace(".", "/") + ".java";
            JavaFileObject jfo = this.jfm.getJavaFileForOutput(StandardLocation.SOURCE_OUTPUT, name, JavaFileObject.Kind.SOURCE, null);
            if (jfo == null) {
                return null;
            }
            return ((Object)jfo.getCharContent(true)).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Class<?> getOutputClass(String fqn) throws ClassNotFoundException {
        if (!this.done) {
            throw new IllegalStateException("cannot call before doCompilation()");
        }
        return this.jfm.getClassLoader(StandardLocation.CLASS_OUTPUT).loadClass(fqn);
    }

    public ClassLoader getOutputClassLoader() {
        return this.jfm.getClassLoader(StandardLocation.CLASS_OUTPUT);
    }

    public void useProcessor(Processor processor) {
        if (this.done) {
            throw new IllegalStateException("cannot call after doCompilation()");
        }
        if (this.processors == null) {
            this.processors = new ArrayList<Processor>();
        }
        this.processors.add(processor);
    }
}

