/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.utils;

import com.jdcloud.sdk.utils.Validate;
import java.util.HashMap;
import java.util.Map;

public final class AttributeMap {
    private final Map<Key<?>, Object> attributes;

    private AttributeMap(Map<? extends Key<?>, ?> attributes) {
        this.attributes = new HashMap(attributes);
    }

    public <T> boolean containsKey(Key<T> typedKey) {
        return this.attributes.containsKey(typedKey);
    }

    public <T> T get(Key<T> key) {
        Validate.notNull(key, "Key to retrieve must not be null.", new Object[0]);
        return key.convertValue(this.attributes.get(key));
    }

    public static AttributeMap empty() {
        return AttributeMap.builder().build();
    }

    public String toString() {
        return this.attributes.toString();
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof AttributeMap && this.attributes.equals(((AttributeMap)obj).attributes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<Key<?>, Object> configuration = new HashMap();

        private Builder() {
        }

        public <T> T get(Key<T> key) {
            Validate.notNull(key, "Key to retrieve must not be null.", new Object[0]);
            return key.convertValue(this.configuration.get(key));
        }

        public <T> Builder put(Key<T> key, T value) {
            Validate.notNull(key, "Key to set must not be null.", new Object[0]);
            this.configuration.put(key, value);
            return this;
        }

        public AttributeMap build() {
            return new AttributeMap(this.configuration);
        }
    }

    public static abstract class Key<T> {
        private final Class<T> valueClass;

        protected Key(Class<T> valueClass) {
            this.valueClass = valueClass;
        }

        final void validateValue(Object value) {
            if (value != null) {
                Validate.isAssignableFrom(this.valueClass, value.getClass(), "Invalid option: %s. Required value of type %s, but was %s.", this, this.valueClass, value.getClass());
            }
        }

        final T convertValue(Object value) {
            this.validateValue(value);
            return this.valueClass.cast(value);
        }
    }
}

